/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.cires.cmg.mvt.adapt.jts;

import edu.colorado.cires.cmg.mvt.VectorTile;
import edu.colorado.cires.cmg.mvt.adapt.jts.IUserDataConverter;
import edu.colorado.cires.cmg.mvt.adapt.jts.JtsAdapter;
import edu.colorado.cires.cmg.mvt.adapt.jts.UserDataKeyValueMapConverter;
import edu.colorado.cires.cmg.mvt.adapt.jts.model.JtsLayer;
import edu.colorado.cires.cmg.mvt.adapt.jts.model.JtsMvt;
import edu.colorado.cires.cmg.mvt.build.MvtLayerBuild;
import edu.colorado.cires.cmg.mvt.build.MvtLayerParams;
import edu.colorado.cires.cmg.mvt.build.MvtLayerProps;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

public final class MvtEncoder {
    public static byte[] encode(JtsMvt mvt) {
        return MvtEncoder.encode(mvt, MvtLayerParams.DEFAULT, new UserDataKeyValueMapConverter());
    }

    public static byte[] encode(JtsMvt mvt, MvtLayerParams mvtLayerParams, IUserDataConverter userDataConverter) {
        VectorTile.Tile.Builder tileBuilder = VectorTile.Tile.newBuilder();
        for (JtsLayer layer : mvt.getLayers()) {
            Collection<Geometry> layerGeoms = layer.getGeometries();
            VectorTile.Tile.Layer.Builder layerBuilder = MvtLayerBuild.newLayerBuilder(layer.getName(), mvtLayerParams);
            MvtLayerProps layerProps = new MvtLayerProps();
            List<VectorTile.Tile.Feature> features = JtsAdapter.toFeatures(layerGeoms, layerProps, userDataConverter);
            layerBuilder.addAllFeatures(features);
            MvtLayerBuild.writeProps(layerBuilder, layerProps);
            VectorTile.Tile.Layer vtl = layerBuilder.build();
            tileBuilder.addLayers(vtl);
        }
        return tileBuilder.build().toByteArray();
    }
}

