/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.cires.cmg.mvt.adapt.jts.model;

import edu.colorado.cires.cmg.mvt.build.MvtLayerParams;
import java.util.ArrayList;
import java.util.Collection;
import org.locationtech.jts.geom.Geometry;

public class JtsLayer {
    private final String name;
    private final Collection<Geometry> geometries;
    private final int extent;

    public JtsLayer(String name) {
        this(name, new ArrayList<Geometry>(0), MvtLayerParams.DEFAULT.extent);
    }

    public JtsLayer(String name, Collection<Geometry> geometries) {
        this(name, geometries, MvtLayerParams.DEFAULT.extent);
    }

    public JtsLayer(String name, Collection<Geometry> geometries, int extent) {
        JtsLayer.validate(name, geometries, extent);
        this.name = name;
        this.geometries = geometries;
        this.extent = extent;
    }

    public Collection<Geometry> getGeometries() {
        return this.geometries;
    }

    public String getName() {
        return this.name;
    }

    public int getExtent() {
        return this.extent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsLayer layer = (JtsLayer)o;
        if (this.extent != layer.getExtent()) {
            return false;
        }
        if (this.name != null ? !this.name.equals(layer.name) : layer.name != null) {
            return false;
        }
        return this.geometries != null ? this.geometries.equals(layer.geometries) : layer.geometries == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + this.extent;
        result = 31 * result + (this.geometries != null ? this.geometries.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Layer{name='" + this.name + '\'' + ", geometries=" + this.geometries + ", extent=" + this.extent + '}';
    }

    private static void validate(String name, Collection<Geometry> geometries, int extent) {
        if (name == null) {
            throw new IllegalArgumentException("layer name is null");
        }
        if (geometries == null) {
            throw new IllegalArgumentException("geometry collection is null");
        }
        if (extent <= 0) {
            throw new IllegalArgumentException("extent is less than or equal to 0");
        }
    }
}

