/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1;

import com.clearblade.cloud.iot.v1.binddevicetogateway.BindDeviceToGatewayRequest;
import com.clearblade.cloud.iot.v1.createdevice.CreateDeviceRequest;
import com.clearblade.cloud.iot.v1.deletedevice.DeleteDeviceRequest;
import com.clearblade.cloud.iot.v1.deviceslist.DevicesListRequest;
import com.clearblade.cloud.iot.v1.devicestateslist.ListDeviceStatesRequest;
import com.clearblade.cloud.iot.v1.exception.ApplicationException;
import com.clearblade.cloud.iot.v1.getdevice.GetDeviceRequest;
import com.clearblade.cloud.iot.v1.getdeviceregistry.GetDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.listdeviceconfigversions.ListDeviceConfigVersionsRequest;
import com.clearblade.cloud.iot.v1.modifycloudtodeviceconfig.ModifyCloudToDeviceConfigRequest;
import com.clearblade.cloud.iot.v1.sendcommandtodevice.SendCommandToDeviceRequest;
import com.clearblade.cloud.iot.v1.unbinddevicefromgateway.UnbindDeviceFromGatewayRequest;
import com.clearblade.cloud.iot.v1.updatedevice.UpdateDeviceRequest;
import com.clearblade.cloud.iot.v1.updatedeviceregistry.UpdateDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.utils.AuthParams;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;

public class AsyncClient {
    static Logger log = Logger.getLogger(AsyncClient.class.getName());
    private String[] responseArray = new String[3];
    private boolean isAdmin = false;
    private AuthParams authParams = new AuthParams();

    private String generateURL(AuthParams authParams, String apiName, String params) {
        return authParams.getApiBaseURL().concat(":443").concat("/api/v/4/webhook/execute/").concat(authParams.getUserSystemKey()).concat(apiName).concat("?" + params);
    }

    private String generateAdminURL(AuthParams authParams, String apiName, String params) {
        return authParams.getBaseURL().concat("/api/v/4/webhook/execute/").concat(authParams.getAdminSystemKey()).concat(apiName).concat("?" + params);
    }

    public String[] get(String apiName, GetDeviceRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, request.toString());
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, DevicesListRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, ListDeviceStatesRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, GetDeviceRegistryRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, ListDeviceConfigVersionsRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String finalURL, String token) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").GET().build();
            CompletableFuture<HttpResponse<String>> response = HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString());
            HttpResponse<String> httpResponse = response.get();
            this.responseArray[0] = String.valueOf(httpResponse.statusCode());
            this.responseArray[1] = "";
            this.responseArray[2] = httpResponse.body();
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, ex.getMessage());
            Thread.currentThread().interrupt();
            throw new ApplicationException(ex);
        }
        catch (Exception ec) {
            log.log(Level.SEVERE, ec.getMessage());
            throw new ApplicationException(ec);
        }
        return this.responseArray;
    }

    public String[] post(String apiName, String params, String body, CreateDeviceRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, SendCommandToDeviceRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getDeviceName().getProject(), request.getDeviceName().getRegistry(), request.getDeviceName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, BindDeviceToGatewayRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, ModifyCloudToDeviceConfigRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getDeviceName().getProject(), request.getDeviceName().getRegistry(), request.getDeviceName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, UnbindDeviceFromGatewayRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String finalURL, String body, String token) {
        try {
            HttpRequest.BodyPublisher jsonPayload = HttpRequest.BodyPublishers.ofString(body);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).method("POST", jsonPayload).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").build();
            CompletableFuture<HttpResponse<String>> response = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(20L)).build().sendAsync(request, HttpResponse.BodyHandlers.ofString());
            HttpResponse<String> httpResponse = response.get();
            this.responseArray[0] = String.valueOf(httpResponse.statusCode());
            this.responseArray[1] = "";
            this.responseArray[2] = httpResponse.body();
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, ex.getMessage());
            Thread.currentThread().interrupt();
            throw new ApplicationException(ex);
        }
        catch (Exception ec) {
            log.log(Level.SEVERE, ec.getMessage());
            throw new ApplicationException(ec);
        }
        return this.responseArray;
    }

    public String[] delete(String apiName, String params, DeleteDeviceRequest request) throws IOException {
        String finalURL = "";
        String token = "";
        if (this.isAdmin) {
            try {
                this.authParams.setAdminCredentials();
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
            finalURL = this.generateAdminURL(this.authParams, apiName, params);
            token = this.authParams.getAdminToken();
        } else {
            try {
                this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
            finalURL = this.generateURL(this.authParams, apiName, params);
            token = this.authParams.getUserToken();
        }
        return this.delete(finalURL, token);
    }

    public String[] delete(String finalURL, String token) {
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").DELETE().build();
            CompletableFuture<HttpResponse<String>> response = HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString());
            HttpResponse<String> httpResponse = response.get();
            this.responseArray[0] = String.valueOf(httpResponse.statusCode());
            this.responseArray[1] = "";
            this.responseArray[2] = httpResponse.body();
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, ex.getMessage());
            Thread.currentThread().interrupt();
            throw new ApplicationException(ex);
        }
        catch (Exception ec) {
            log.log(Level.SEVERE, ec.getMessage());
            throw new ApplicationException(ec);
        }
        return this.responseArray;
    }

    public String[] update(String apiName, String params, String body, UpdateDeviceRegistryRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.update(finalURL, body, token);
    }

    public String[] update(String apiName, String params, String body, UpdateDeviceRequest request) throws IOException, ParseException {
        try {
            this.authParams.setRegistryCredentials(request.getDeviceName().getProject(), request.getDeviceName().getRegistry(), request.getDeviceName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.update(finalURL, body, token);
    }

    public String[] update(String finalURL, String body, String token) {
        try {
            HttpRequest.BodyPublisher jsonPayload = HttpRequest.BodyPublishers.ofString(body);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).method("PATCH", jsonPayload).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").build();
            CompletableFuture<HttpResponse<String>> response = HttpClient.newBuilder().build().sendAsync(request, HttpResponse.BodyHandlers.ofString());
            HttpResponse<String> httpResponse = response.get();
            this.responseArray[0] = String.valueOf(httpResponse.statusCode());
            this.responseArray[1] = "";
            this.responseArray[2] = httpResponse.body();
        }
        catch (InterruptedException ex) {
            log.log(Level.SEVERE, ex.getMessage());
            Thread.currentThread().interrupt();
            throw new ApplicationException(ex);
        }
        catch (Exception ec) {
            log.log(Level.SEVERE, ec.getMessage());
            throw new ApplicationException(ec);
        }
        return this.responseArray;
    }

    public String[] asyncCreateDeviceRegistry(String apiName, String params, String body, boolean isAdmin) throws IOException {
        String finalURL = "";
        String token = "";
        if (isAdmin) {
            try {
                this.authParams.setAdminCredentials();
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
            finalURL = this.generateAdminURL(this.authParams, apiName, params);
            token = this.authParams.getAdminToken();
        }
        return this.post(finalURL, body, token);
    }

    public String[] asyncDeleteDeviceRegistry(String apiName, String params, boolean isAdmin) throws IOException {
        try {
            this.authParams.setAdminCredentials();
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateAdminURL(this.authParams, apiName, params);
        String token = this.authParams.getAdminToken();
        return this.delete(finalURL, token);
    }

    public String[] asyncListDeviceRegistries(String apiName, String params, boolean isAdmin) throws IOException {
        String finalURL = "";
        String token = "";
        if (isAdmin) {
            try {
                this.authParams.setAdminCredentials();
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
            finalURL = this.generateAdminURL(this.authParams, apiName, params);
            token = this.authParams.getAdminToken();
        }
        return this.get(finalURL, token);
    }
}

