/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1;

import com.clearblade.cloud.iot.v1.AsyncClient;
import com.clearblade.cloud.iot.v1.SyncClient;
import com.clearblade.cloud.iot.v1.createdeviceregistry.CreateDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.deletedeviceregistry.DeleteDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.exception.ApplicationException;
import com.clearblade.cloud.iot.v1.getdeviceregistry.GetDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.registrytypes.DeviceRegistry;
import com.clearblade.cloud.iot.v1.updatedeviceregistry.UpdateDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.utils.ConfigParameters;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClearBladeRegistryManager {
    static Logger log = Logger.getLogger(ClearBladeRegistryManager.class.getName());
    ConfigParameters configParameters = ConfigParameters.getInstance();

    public DeviceRegistry getRegistry(GetDeviceRegistryRequest request) throws ApplicationException {
        SyncClient syncClient = new SyncClient();
        String[] responseArray = syncClient.get(this.configParameters.getCloudiotURLExtension(), request.toString(), request);
        if (responseArray[0] != null) {
            int responseCode = Integer.parseInt(responseArray[0]);
            if (responseCode == 200) {
                DeviceRegistry deviceRegistry = DeviceRegistry.newBuilder().build();
                deviceRegistry.loadFromString(responseArray[2]);
                return deviceRegistry;
            }
            throw new ApplicationException(responseArray[2]);
        }
        return null;
    }

    public DeviceRegistry asyncGetDeviceRegistry(GetDeviceRegistryRequest request) throws ApplicationException {
        try {
            AsyncClient asyncClient = new AsyncClient();
            String[] responseArray = asyncClient.get(this.configParameters.getCloudiotURLExtension(), request.toString(), request);
            if (responseArray[0] != null) {
                int responseCode = Integer.parseInt(responseArray[0]);
                if (responseCode == 200) {
                    DeviceRegistry deviceRegistry = DeviceRegistry.newBuilder().build();
                    deviceRegistry.loadFromString(responseArray[2]);
                    return deviceRegistry;
                }
                throw new ApplicationException(responseArray[2]);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return null;
    }

    public DeviceRegistry createDeviceRegistry(CreateDeviceRegistryRequest request) throws ApplicationException {
        SyncClient syncClient = new SyncClient();
        String[] bodyParams = request.getBodyAndParams();
        String[] responseArray = syncClient.post(this.configParameters.getCloudiotURLExtension(), bodyParams[0], bodyParams[1], true, request);
        if (responseArray[0] != null) {
            int responseCode = Integer.parseInt(responseArray[0]);
            if (responseCode == 200) {
                DeviceRegistry deviceRegistry = DeviceRegistry.newBuilder().build();
                deviceRegistry.loadFromString(responseArray[2]);
                return deviceRegistry;
            }
            throw new ApplicationException(responseArray[2]);
        }
        return null;
    }

    public DeviceRegistry asyncCreateDeviceRegistry(CreateDeviceRegistryRequest request) throws ApplicationException {
        try {
            AsyncClient asyncClient = new AsyncClient();
            String[] bodyParams = request.getBodyAndParams();
            String[] responseArray = asyncClient.asyncCreateDeviceRegistry(this.configParameters.getCloudiotURLExtension(), bodyParams[0], bodyParams[1], true);
            if (responseArray[0] != null) {
                int responseCode = Integer.parseInt(responseArray[0]);
                if (responseCode == 200) {
                    DeviceRegistry deviceRegistry = DeviceRegistry.newBuilder().build();
                    deviceRegistry.loadFromString(responseArray[2]);
                    return deviceRegistry;
                }
                throw new ApplicationException(responseArray[2]);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return null;
    }

    public DeviceRegistry updateDeviceRegistry(UpdateDeviceRegistryRequest request) throws ApplicationException {
        try {
            SyncClient syncClient = new SyncClient();
            String[] bodyParams = request.getBodyAndParams();
            String[] responseArray = syncClient.update(this.configParameters.getCloudiotURLExtension(), bodyParams[0], bodyParams[1], request);
            if (responseArray[0] != null) {
                int responseCode = Integer.parseInt(responseArray[0]);
                if (responseCode == 200) {
                    DeviceRegistry deviceRegistry = DeviceRegistry.newBuilder().build();
                    deviceRegistry.loadFromString(responseArray[2]);
                    return deviceRegistry;
                }
                throw new ApplicationException(responseArray[2]);
            }
        }
        catch (Exception e) {
            Thread.currentThread().interrupt();
            throw new ApplicationException(e.getMessage(), e);
        }
        return null;
    }

    public DeviceRegistry asyncUpdateDeviceRegistry(UpdateDeviceRegistryRequest request) throws ApplicationException {
        try {
            AsyncClient asyncClient = new AsyncClient();
            String[] bodyParams = request.getBodyAndParams();
            String[] responseArray = asyncClient.update(this.configParameters.getCloudiotURLExtension(), bodyParams[0], bodyParams[1], request);
            if (responseArray[0] != null) {
                int responseCode = Integer.parseInt(responseArray[0]);
                if (responseCode == 200) {
                    DeviceRegistry deviceRegistry = DeviceRegistry.newBuilder().build();
                    deviceRegistry.loadFromString(responseArray[2]);
                    return deviceRegistry;
                }
                throw new ApplicationException(responseArray[2]);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return null;
    }

    public void deleteDeviceRegistry(DeleteDeviceRegistryRequest request) throws ApplicationException {
        SyncClient syncClient = new SyncClient();
        String bodyParams = request.getParams();
        String[] responseArray = syncClient.delete(this.configParameters.getCloudiotURLExtension(), bodyParams, true);
        if (responseArray[0] != null) {
            int responseCode = Integer.parseInt(responseArray[0]);
            if (responseCode == 200 || responseCode == 204) {
                log.log(Level.INFO, () -> "Response code " + responseArray[0] + " received with message" + responseArray[2]);
            } else {
                throw new ApplicationException(responseArray[2]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void asyncDeleteDeviceRegistry(DeleteDeviceRegistryRequest request) throws ApplicationException {
        try {
            AsyncClient asyncClient = new AsyncClient();
            String bodyParams = request.getParams();
            String[] responseArray = asyncClient.asyncDeleteDeviceRegistry(this.configParameters.getCloudiotURLExtension(), bodyParams, true);
            if (responseArray[0] != null) {
                int responseCode = Integer.parseInt(responseArray[0]);
                if (responseCode != 200 && responseCode != 204) throw new ApplicationException(responseArray[2]);
                System.out.println("DeleteDeviceRegistry execution successful");
                return;
            } else {
                System.out.println("DeleteDeviceRegistry execution failed");
            }
            return;
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }
}

