/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1;

import com.clearblade.cloud.iot.v1.binddevicetogateway.BindDeviceToGatewayRequest;
import com.clearblade.cloud.iot.v1.createdevice.CreateDeviceRequest;
import com.clearblade.cloud.iot.v1.createdeviceregistry.CreateDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.deletedevice.DeleteDeviceRequest;
import com.clearblade.cloud.iot.v1.deviceslist.DevicesListRequest;
import com.clearblade.cloud.iot.v1.devicestateslist.ListDeviceStatesRequest;
import com.clearblade.cloud.iot.v1.exception.ApplicationException;
import com.clearblade.cloud.iot.v1.getdevice.GetDeviceRequest;
import com.clearblade.cloud.iot.v1.getdeviceregistry.GetDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.listdeviceconfigversions.ListDeviceConfigVersionsRequest;
import com.clearblade.cloud.iot.v1.modifycloudtodeviceconfig.ModifyCloudToDeviceConfigRequest;
import com.clearblade.cloud.iot.v1.sendcommandtodevice.SendCommandToDeviceRequest;
import com.clearblade.cloud.iot.v1.unbinddevicefromgateway.UnbindDeviceFromGatewayRequest;
import com.clearblade.cloud.iot.v1.updatedevice.UpdateDeviceRequest;
import com.clearblade.cloud.iot.v1.updatedeviceregistry.UpdateDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.utils.AuthParams;
import com.clearblade.cloud.iot.v1.utils.ConfigParameters;
import java.io.IOException;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SyncClient {
    static Logger log = Logger.getLogger(SyncClient.class.getName());
    private ConfigParameters configParameters = ConfigParameters.getInstance();
    private AuthParams authParams = new AuthParams();

    private String generateURL(AuthParams authParams, String apiName, String params) {
        return authParams.getApiBaseURL().concat(this.configParameters.getEndpointPort()).concat(this.configParameters.getWebhook()).concat(authParams.getUserSystemKey()).concat(apiName).concat("?" + params);
    }

    private String generateAdminURL(AuthParams authParams, String apiName, String params) {
        return authParams.getBaseURL().concat(this.configParameters.getWebhook()).concat(authParams.getAdminSystemKey()).concat(apiName).concat("?" + params);
    }

    public String[] get(String apiName, GetDeviceRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, request.toString());
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, DevicesListRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, ListDeviceStatesRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, GetDeviceRegistryRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, ListDeviceConfigVersionsRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.get(finalURL, token);
    }

    public String[] get(String apiName, String params, boolean isAdmin) {
        String finalURL = "";
        String token = "";
        if (isAdmin) {
            try {
                this.authParams.setAdminCredentials();
            }
            catch (IOException e) {
                throw new ApplicationException(e);
            }
            finalURL = this.generateAdminURL(this.authParams, apiName, params);
            token = this.authParams.getAdminToken();
        }
        return this.get(finalURL, token);
    }

    public String[] get(String finalURL, String token) {
        String[] responseArray = new String[3];
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").GET().build();
            HttpResponse<String> response = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).build().send(request, HttpResponse.BodyHandlers.ofString());
            responseArray[0] = String.valueOf(response.statusCode());
            responseArray[1] = "";
            responseArray[2] = response.body();
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, e.getMessage());
            Thread.currentThread().interrupt();
            throw new ApplicationException(e);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            throw new ApplicationException(ex);
        }
        return responseArray;
    }

    public String[] post(String apiName, String params, String body, CreateDeviceRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, SendCommandToDeviceRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getDeviceName().getProject(), request.getDeviceName().getRegistry(), request.getDeviceName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, BindDeviceToGatewayRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, ModifyCloudToDeviceConfigRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getDeviceName().getProject(), request.getDeviceName().getRegistry(), request.getDeviceName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, UnbindDeviceFromGatewayRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.post(finalURL, body, token);
    }

    public String[] post(String apiName, String params, String body, boolean isAdmin, CreateDeviceRegistryRequest request) {
        String finalURL = "";
        String token = "";
        if (isAdmin) {
            try {
                this.authParams.setAdminCredentials();
            }
            catch (IOException e) {
                throw new ApplicationException(e);
            }
            finalURL = this.generateAdminURL(this.authParams, apiName, params);
            token = this.authParams.getAdminToken();
        }
        return this.post(finalURL, body, token);
    }

    public String[] post(String finalURL, String body, String token) {
        String[] responseArray = new String[3];
        try {
            HttpRequest.BodyPublisher jsonPayload = HttpRequest.BodyPublishers.ofString(body);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).method("POST", jsonPayload).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").build();
            HttpResponse<String> response = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).build().send(request, HttpResponse.BodyHandlers.ofString());
            responseArray[0] = String.valueOf(response.statusCode());
            responseArray[1] = "";
            responseArray[2] = response.body();
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, e.getMessage());
            Thread.currentThread().interrupt();
            throw new ApplicationException(e);
        }
        catch (Exception ec) {
            log.log(Level.SEVERE, ec.getMessage());
            throw new ApplicationException(ec);
        }
        return responseArray;
    }

    public String[] delete(String apiName, String params, boolean isAdmin, DeleteDeviceRequest request) {
        try {
            this.authParams.setRegistryCredentials(request.getName().getProject(), request.getName().getRegistry(), request.getName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.delete(finalURL, token);
    }

    public String[] delete(String apiName, String params, boolean isAdmin) {
        try {
            this.authParams.setAdminCredentials();
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateAdminURL(this.authParams, apiName, params);
        String token = this.authParams.getAdminToken();
        return this.delete(finalURL, token);
    }

    public String[] delete(String finalURL, String token) {
        String[] responseArray = new String[3];
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").DELETE().build();
            HttpResponse<String> response = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).build().send(request, HttpResponse.BodyHandlers.ofString());
            responseArray[0] = String.valueOf(response.statusCode());
            responseArray[1] = "";
            responseArray[2] = response.body();
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, e.getMessage());
            Thread.currentThread().interrupt();
            throw new ApplicationException(e);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            throw new ApplicationException(ex);
        }
        return responseArray;
    }

    public String[] update(String apiName, String params, String body, UpdateDeviceRequest request) throws InterruptedException {
        try {
            this.authParams.setRegistryCredentials(request.getDeviceName().getProject(), request.getDeviceName().getRegistry(), request.getDeviceName().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.update(finalURL, body, token);
    }

    public String[] update(String apiName, String params, String body, UpdateDeviceRegistryRequest request) throws InterruptedException {
        try {
            this.authParams.setRegistryCredentials(request.getParent().getProject(), request.getParent().getRegistry(), request.getParent().getLocation());
        }
        catch (Exception e) {
            throw new ApplicationException(e);
        }
        String finalURL = this.generateURL(this.authParams, apiName, params);
        String token = this.authParams.getUserToken();
        return this.update(finalURL, body, token);
    }

    public String[] update(String finalURL, String body, String token) throws InterruptedException {
        String[] responseArray = new String[3];
        try {
            HttpRequest.BodyPublisher jsonPayload = HttpRequest.BodyPublishers.ofString(body);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).method("PATCH", jsonPayload).headers("Content-Type", "application/json", "ClearBlade-UserToken", token, "Accept", "application/json").build();
            HttpResponse<String> response = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).build().send(request, HttpResponse.BodyHandlers.ofString());
            responseArray[0] = String.valueOf(response.statusCode());
            responseArray[1] = "";
            responseArray[2] = response.body();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ex.getMessage());
            throw new ApplicationException(ex);
        }
        return responseArray;
    }
}

