/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.binddevicetogateway;

import com.clearblade.cloud.iot.v1.registrytypes.RegistryName;
import org.json.simple.JSONObject;

public class BindDeviceToGatewayRequest {
    private final String parent;
    private final String gateway;
    private final String device;
    JSONObject requestParams;
    JSONObject bodyParams;

    private BindDeviceToGatewayRequest(Builder builder) {
        this.parent = builder.parent;
        this.gateway = builder.gateway;
        this.device = builder.device;
    }

    public JSONObject getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(JSONObject requestParams) {
        this.requestParams = requestParams;
    }

    public JSONObject getBodyParams() {
        return this.bodyParams;
    }

    public void setBodyParams(JSONObject bodyParams) {
        this.bodyParams = bodyParams;
    }

    public RegistryName getParent() {
        return RegistryName.parse(this.parent);
    }

    public String toString() {
        this.requestParams = new JSONObject();
        this.bodyParams = new JSONObject();
        String method = "bindDeviceToGateway";
        this.requestParams.put((Object)"method", (Object)method);
        this.requestParams.put((Object)"parent", (Object)this.parent);
        this.bodyParams.put((Object)"gatewayId", (Object)this.gateway);
        this.bodyParams.put((Object)"deviceId", (Object)this.device);
        this.setRequestParams(this.requestParams);
        this.setBodyParams(this.bodyParams);
        return "parent=" + this.parent + ",gateway=" + this.gateway + ", device= " + this.device;
    }

    public String[] getBodyAndParams() {
        String[] output = new String[2];
        String params = "parent=" + this.parent + "&method=bindDeviceToGateway";
        this.bodyParams = new JSONObject();
        this.bodyParams.put((Object)"gatewayId", (Object)this.gateway);
        this.bodyParams.put((Object)"deviceId", (Object)this.device);
        output[0] = params;
        output[1] = this.bodyParams.toJSONString();
        return output;
    }

    public static class Builder {
        private String parent;
        private String gateway;
        private String device;

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder setGateway(String gateway) {
            this.gateway = gateway;
            return this;
        }

        public Builder setDevice(String device) {
            this.device = device;
            return this;
        }

        public BindDeviceToGatewayRequest build() {
            return new BindDeviceToGatewayRequest(this);
        }
    }
}

