/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.createdevice;

import com.clearblade.cloud.iot.v1.devicetypes.Device;
import com.clearblade.cloud.iot.v1.registrytypes.RegistryName;

public class CreateDeviceRequest {
    private final String parent;
    private final Device device;

    private CreateDeviceRequest(Builder builder) {
        this.parent = builder.parent;
        this.device = builder.device;
    }

    public RegistryName getParent() {
        return RegistryName.parse(this.parent);
    }

    public String[] getParams() {
        String[] params = new String[]{"parent=" + this.getParent().getRegistryFullName(), this.device.createDeviceJSONObject()};
        return params;
    }

    public static class Builder {
        private String parent;
        private Device device;

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder setDevice(Device device) {
            this.device = device;
            return this;
        }

        public CreateDeviceRequest build() {
            return new CreateDeviceRequest(this);
        }
    }
}

