/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.deviceslist;

import com.clearblade.cloud.iot.v1.devicetypes.GatewayListOptions;
import com.clearblade.cloud.iot.v1.registrytypes.RegistryName;

public class DevicesListRequest {
    private String parent;
    private String deviceNumIds;
    private String deviceIds;
    private String fieldMask;
    private int pageSize = -1;
    private String pageToken;
    private GatewayListOptions gatewayListOptions;

    private DevicesListRequest(Builder builder) {
        this.parent = builder.parent;
        this.deviceNumIds = builder.deviceNumIds;
        this.deviceIds = builder.deviceIds;
        this.fieldMask = builder.fieldMask;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
        this.gatewayListOptions = builder.gatewayListOptions;
    }

    public RegistryName getParent() {
        return RegistryName.parse(this.parent);
    }

    public String toString() {
        return this.parent.toString();
    }

    public String getParamsForList() {
        Object params = "";
        params = "parent=" + this.parent;
        if (this.deviceNumIds != null) {
            params = (String)params + "&deviceNumIds=" + this.deviceNumIds;
        }
        if (this.deviceIds != null) {
            params = (String)params + "&deviceIds=" + this.deviceIds;
        }
        if (this.fieldMask != null) {
            params = (String)params + "&fieldMask=" + this.fieldMask;
        }
        if (this.pageSize > 0) {
            params = (String)params + "&pageSize=" + String.valueOf(this.pageSize);
        }
        if (this.pageToken != null) {
            params = (String)params + "&pageToken=" + this.pageToken;
        }
        if (this.gatewayListOptions != null) {
            if (this.gatewayListOptions.getGatewayType() != null) {
                params = (String)params + "&gatewayListOptions.gatewayType=" + this.gatewayListOptions.getGatewayType().name();
            }
            if (this.gatewayListOptions.getAssociationsDeviceId() != null) {
                params = (String)params + "&gatewayListOptions.associationsDeviceId=" + this.gatewayListOptions.getAssociationsDeviceId();
            }
            if (this.gatewayListOptions.getAssociationsGatewayId() != null) {
                params = (String)params + "&gatewayListOptions.associationsGatewayId=" + this.gatewayListOptions.getAssociationsGatewayId();
            }
        }
        return params;
    }

    public static class Builder {
        private String parent;
        private String deviceNumIds;
        private String deviceIds;
        private String fieldMask;
        private int pageSize;
        private String pageToken;
        private GatewayListOptions gatewayListOptions;

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setParent(String parent) {
            this.parent = parent;
            return this;
        }

        public Builder setDeviceNumIds(String deviceNumIds) {
            this.deviceNumIds = deviceNumIds;
            return this;
        }

        public Builder setDeviceIds(String deviceIds) {
            this.deviceIds = deviceIds;
            return this;
        }

        public Builder setFieldMask(String fieldMask) {
            this.fieldMask = fieldMask;
            return this;
        }

        public Builder setPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder setPageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public Builder setGatewayListOptions(GatewayListOptions gatewayListOptions) {
            this.gatewayListOptions = gatewayListOptions;
            return this;
        }

        public DevicesListRequest build() {
            return new DevicesListRequest(this);
        }
    }
}

