/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.deviceslist;

import com.clearblade.cloud.iot.v1.devicetypes.Device;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class DevicesListResponse {
    static Logger log = Logger.getLogger(DevicesListResponse.class.getName());
    private String nextPageToken;
    private List<Device> devicesList;

    protected DevicesListResponse(Builder builder) {
        this.devicesList = builder.devicesList;
        this.nextPageToken = builder.nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public List<Device> getDevicesList() {
        return this.devicesList;
    }

    public void setDevicesList(List<Device> devicesList) {
        this.devicesList = devicesList;
    }

    public static class Builder {
        private String nextPageToken;
        private List<Device> devicesList = new ArrayList<Device>();

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder buildResponse(String jsonString) {
            try {
                JSONObject jsonObj = new JSONObject();
                JSONParser jsonParser = new JSONParser();
                jsonObj = (JSONObject)jsonParser.parse(jsonString);
                JSONArray devicesArray = (JSONArray)jsonObj.get((Object)"devices");
                for (JSONObject deviceJson : devicesArray) {
                    Device deviceObj = Device.newBuilder().build();
                    deviceObj.loadFromString(deviceJson.toString());
                    this.devicesList.add(deviceObj);
                }
                if (jsonObj.containsKey((Object)"nextPageToken")) {
                    this.nextPageToken = (String)jsonObj.get((Object)"nextPageToken");
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage());
            }
            return this;
        }

        public DevicesListResponse build() {
            return new DevicesListResponse(this);
        }
    }
}

