/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.devicestateslist;

import com.clearblade.cloud.iot.v1.devicetypes.DeviceState;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ListDeviceStatesResponse {
    static Logger log = Logger.getLogger(ListDeviceStatesResponse.class.getName());
    private List<DeviceState> deviceStatesList = new ArrayList<DeviceState>();

    protected ListDeviceStatesResponse(Builder builder) {
        this.deviceStatesList = builder.deviceStatesList;
    }

    public String toString() {
        return "";
    }

    public List<DeviceState> getDeviceStatesList() {
        return this.deviceStatesList;
    }

    public void setDeviceStatesList(List<DeviceState> deviceStatesList) {
        this.deviceStatesList = deviceStatesList;
    }

    public static class Builder {
        private List<DeviceState> deviceStatesList = new ArrayList<DeviceState>();

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public ListDeviceStatesResponse build() {
            return new ListDeviceStatesResponse(this);
        }

        public Builder buildResponse(String stateList) {
            try {
                JSONObject jsonObj = new JSONObject();
                JSONParser jsonParser = new JSONParser();
                jsonObj = (JSONObject)jsonParser.parse(stateList);
                JSONArray stateArray = (JSONArray)jsonObj.get((Object)"deviceStates");
                for (JSONObject stateJson : stateArray) {
                    DeviceState stateObj = DeviceState.newBuilder().setBinaryData((String)stateJson.get((Object)"binaryData")).setUpdateTime((String)stateJson.get((Object)"updateTime")).build();
                    this.deviceStatesList.add(stateObj);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage());
            }
            return this;
        }
    }
}

