/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.devicetypes;

import com.clearblade.cloud.iot.v1.devicetypes.DeviceConfig;
import com.clearblade.cloud.iot.v1.devicetypes.DeviceCredential;
import com.clearblade.cloud.iot.v1.devicetypes.DeviceState;
import com.clearblade.cloud.iot.v1.devicetypes.GatewayAuthMethod;
import com.clearblade.cloud.iot.v1.devicetypes.GatewayConfig;
import com.clearblade.cloud.iot.v1.devicetypes.GatewayType;
import com.clearblade.cloud.iot.v1.devicetypes.Status;
import com.clearblade.cloud.iot.v1.utils.LogLevel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Device {
    static Logger log = Logger.getLogger(Device.class.getName());
    private String id;
    private String name;
    private String numId;
    private List<DeviceCredential> credentials;
    private String lastHeartbeatTime;
    private String lastEventTime;
    private String lastStateTime;
    private String lastConfigAckTime;
    private String lastConfigSendTime;
    private boolean blocked;
    private String lastErrorTime;
    private Status lastErrorStatus;
    private DeviceConfig config;
    private DeviceState state;
    private LogLevel logLevel;
    private Map<String, String> metadata;
    private GatewayConfig gatewayConfig;

    public Device() {
        this.id = null;
        this.name = null;
        this.numId = null;
        this.credentials = new ArrayList<DeviceCredential>();
        this.lastHeartbeatTime = null;
        this.lastEventTime = null;
        this.lastStateTime = null;
        this.lastConfigAckTime = null;
        this.lastConfigSendTime = null;
        this.blocked = false;
        this.lastErrorTime = null;
        this.lastErrorStatus = new Status();
        this.lastErrorStatus.setCode(0);
        this.lastErrorStatus.setMessage("");
        this.config = new DeviceConfig();
        this.config.setCloudUpdateTime("");
        this.config.setBinaryData("");
        this.config.setDeviceAckTime("");
        this.config.setVersion("");
        this.state = new DeviceState();
        this.state.setBinaryData("");
        this.state.setUpdateTime("");
        this.logLevel = LogLevel.NONE;
        this.metadata = new HashMap<String, String>();
        this.gatewayConfig = new GatewayConfig();
        this.gatewayConfig.setGatewayAuthMethod(GatewayAuthMethod.UNRECOGNIZED);
        this.gatewayConfig.setGatewayType(GatewayType.NON_GATEWAY);
        this.gatewayConfig.setLastAccessedGatewayId("");
        this.gatewayConfig.setLastAccessedGatewayTime("");
    }

    private Device(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.numId = builder.getNumId();
        this.credentials = builder.getCredentials();
        this.lastHeartbeatTime = builder.getLastHeartbeatTime();
        this.lastEventTime = builder.getLastEventTime();
        this.lastStateTime = builder.getLastStateTime();
        this.lastConfigAckTime = builder.getLastConfigAckTime();
        this.lastConfigSendTime = builder.getLastConfigSendTime();
        this.blocked = builder.isBlocked();
        this.lastErrorTime = builder.getLastErrorTime();
        this.lastErrorStatus = builder.getLastErrorStatus();
        this.config = builder.getConfig();
        this.state = builder.getState();
        this.logLevel = builder.getLogLevel();
        this.metadata = builder.getMetadata();
        this.gatewayConfig = builder.getGatewayConfig();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static Device of(String id, String name, String numId, List<DeviceCredential> credentials, String lastHeartbeatTime, String lastEventTime, String lastStateTime, String lastConfigAckTime, String lastConfigSendTime, boolean blocked, String lastErrorTime, Status lastErrorStatus, DeviceConfig config, DeviceState state, LogLevel logLevel, Map<String, String> metadata, GatewayConfig gatewayConfig) {
        return Device.newBuilder().setId(id).setName(name).setNumId(numId).setCredentials(credentials).setLastHeartbeatTime(lastHeartbeatTime).setLastEventTime(lastEventTime).setLastStateTime(lastStateTime).setLastConfigAckTime(lastConfigAckTime).setLastConfigSendTime(lastConfigSendTime).setBlocked(blocked).setLastErrorTime(lastErrorTime).setLastErrorStatus(lastErrorStatus).setConfig(config).setState(state).setLogLevel(logLevel).setMetadata(metadata).setGatewayConfig(gatewayConfig).build();
    }

    public static Device patch(String id, String name, LogLevel logLevel, boolean blocked) {
        return Device.newBuilder().setId(id).setName(name).setLogLevel(logLevel).setBlocked(blocked).build();
    }

    public static String format(String id, String name, String numId, List<DeviceCredential> credentials, String lastHeartbeatTime, String lastEventTime, String lastStateTime, String lastConfigAckTime, String lastConfigSendTime, boolean blocked, String lastErrorTime, Status lastErrorStatus, DeviceConfig config, DeviceState state, LogLevel logLevel, Map<String, String> metadata, GatewayConfig gatewayConfig) {
        return Device.newBuilder().setId(id).setName(name).setNumId(numId).setCredentials(credentials).setLastHeartbeatTime(lastHeartbeatTime).setLastEventTime(lastEventTime).setLastStateTime(lastStateTime).setLastConfigAckTime(lastConfigAckTime).setLastConfigSendTime(lastConfigSendTime).setBlocked(blocked).setLastErrorTime(lastErrorTime).setLastErrorStatus(lastErrorStatus).setConfig(config).setState(state).setLogLevel(logLevel).setMetadata(metadata).setGatewayConfig(gatewayConfig).build().toString();
    }

    public String toString() {
        String deviceStr = "";
        deviceStr = deviceStr.concat("id=" + this.id + ",name=" + this.name + ",numId=" + this.numId + ",credentials=" + this.credentials + ",lastHeartbeatTime=" + this.lastHeartbeatTime + ",lastEventTime=" + this.lastEventTime + ",lastStateTime=" + this.lastStateTime + ",lastConfigAckTime=" + this.lastConfigAckTime + ",lastConfigSendTime=" + this.lastConfigSendTime + ",blocked=" + this.blocked + ",lastErrorTime=" + this.lastErrorTime + ",lastErrorStatus=" + this.lastErrorStatus + ",config=" + this.config + ",state=" + this.state + ",logLevel=" + this.logLevel + ",metadata=" + this.metadata + ",gatewayConfig=" + this.gatewayConfig);
        return deviceStr;
    }

    public String createDeviceJSONObject() {
        String bodyStr = "";
        JSONObject deviceObj = new JSONObject();
        deviceObj.put((Object)"id", (Object)this.id);
        deviceObj.put((Object)"name", (Object)this.name);
        if (this.numId != null) {
            deviceObj.put((Object)"numId", (Object)this.numId);
        }
        JSONArray jsonArray = new JSONArray();
        if (this.credentials != null && this.credentials.size() > 0) {
            for (int i = 0; i < this.credentials.size(); ++i) {
                if (this.credentials.get(i).isEmpty()) continue;
                DeviceCredential credentialObj = this.credentials.get(i);
                jsonArray.add((Object)credentialObj.toJSONObject());
            }
        }
        deviceObj.put((Object)"credentials", (Object)jsonArray);
        deviceObj.put((Object)"gatewayConfig", (Object)this.gatewayConfig.toJSONObject());
        deviceObj.put((Object)"logLevel", (Object)this.logLevel.name());
        if (this.lastHeartbeatTime != null) {
            deviceObj.put((Object)"lastHeartbeatTime", (Object)this.lastHeartbeatTime);
        }
        if (this.lastEventTime != null) {
            deviceObj.put((Object)"lastEventTime", (Object)this.lastEventTime);
        }
        if (this.lastStateTime != null) {
            deviceObj.put((Object)"lastStateTime", (Object)this.lastStateTime);
        }
        if (this.lastConfigAckTime != null) {
            deviceObj.put((Object)"lastConfigAckTime", (Object)this.lastConfigAckTime);
        }
        if (this.lastConfigSendTime != null) {
            deviceObj.put((Object)"lastConfigSendTime", (Object)this.lastConfigSendTime);
        }
        deviceObj.put((Object)"blocked", (Object)this.blocked);
        if (this.lastErrorTime != null) {
            deviceObj.put((Object)"lastErrorTime", (Object)this.lastErrorTime);
        }
        if (this.metadata != null && this.metadata.size() > 0) {
            Set<String> metaSet = this.metadata.keySet();
            Iterator<String> itr = metaSet.iterator();
            JSONObject jsonObject = new JSONObject();
            while (itr.hasNext()) {
                String key = itr.next();
                String value = this.metadata.get(key).toString();
                jsonObject.put((Object)key, (Object)value);
            }
            deviceObj.put((Object)"metadata", (Object)jsonObject);
        }
        if (this.lastErrorStatus != null && this.lastErrorStatus.getCode() != 0) {
            deviceObj.put((Object)"lastErrorStatus", (Object)this.lastErrorStatus.toJSONObject());
        }
        String lastEventTime = "";
        if (this.lastEventTime != null) {
            lastEventTime = this.lastEventTime.toString();
            deviceObj.put((Object)"lastEventTime", (Object)lastEventTime);
        }
        if (this.config != null) {
            deviceObj.put((Object)"config", (Object)this.config.toJSONObject());
        }
        if (this.state != null) {
            deviceObj.put((Object)"state", (Object)this.state.toJSONObject());
        }
        bodyStr = deviceObj.toString();
        return bodyStr;
    }

    public void loadFromString(String inputStr) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject deviceObj = (JSONObject)parser.parse(inputStr);
            if (deviceObj != null && deviceObj.size() > 0) {
                Set deviceSet = deviceObj.keySet();
                for (String key : deviceSet) {
                    JSONObject gatewayConfigJsonObject;
                    JSONObject metadataJsonObject;
                    Object value = deviceObj.get((Object)key);
                    if (key.equals("id")) {
                        this.id = value.toString();
                    }
                    if (key.equals("name")) {
                        this.name = value.toString();
                    }
                    if (key.equals("numId")) {
                        this.numId = value.toString();
                    }
                    if (key.equals("lastHeartbeatTime")) {
                        this.lastHeartbeatTime = value.toString();
                    }
                    if (key.equals("lastEventTime")) {
                        this.lastEventTime = value.toString();
                    }
                    if (key.equals("lastStateTime")) {
                        this.lastStateTime = value.toString();
                    }
                    if (key.equals("lastConfigAckTime")) {
                        this.lastConfigAckTime = value.toString();
                    }
                    if (key.equals("lastConfigSendTime")) {
                        this.lastConfigSendTime = value.toString();
                    }
                    if (key.equals("blocked")) {
                        this.blocked = Boolean.valueOf(value.toString());
                    }
                    if (key.equals("lastErrorTime")) {
                        this.lastErrorTime = value.toString();
                    }
                    if (key.equals("lastErrorStatus")) {
                        JSONObject errorStatus = (JSONObject)value;
                        Status status = new Status();
                        if (errorStatus.containsKey((Object)"code")) {
                            status.setCode(errorStatus.get((Object)"code"));
                        }
                        if (errorStatus.containsKey((Object)"message")) {
                            status.setMessage((String)errorStatus.get((Object)"message"));
                        }
                        this.lastErrorStatus = status;
                    }
                    if (key.equals("config")) {
                        JSONObject configJsonObject = (JSONObject)value;
                        DeviceConfig deviceCfg = new DeviceConfig();
                        if (configJsonObject.containsKey((Object)"version")) {
                            deviceCfg.setVersion((String)configJsonObject.get((Object)"version"));
                        }
                        if (configJsonObject.containsKey((Object)"cloudUpdateTime")) {
                            deviceCfg.setCloudUpdateTime((String)configJsonObject.get((Object)"cloudUpdateTime"));
                        }
                        if (configJsonObject.containsKey((Object)"deviceAckTime")) {
                            deviceCfg.setDeviceAckTime((String)configJsonObject.get((Object)"deviceAckTime"));
                        }
                        if (configJsonObject.containsKey((Object)"binaryData")) {
                            deviceCfg.setBinaryData((String)configJsonObject.get((Object)"binaryData"));
                        }
                        this.config = deviceCfg;
                    }
                    if (key.equals("state")) {
                        JSONObject stateJsonObject = (JSONObject)value;
                        DeviceState deviceState = new DeviceState();
                        if (stateJsonObject.containsKey((Object)"binaryData")) {
                            deviceState.setBinaryData((String)stateJsonObject.get((Object)"binaryData"));
                        }
                        if (stateJsonObject.containsKey((Object)"updateTime")) {
                            deviceState.setUpdateTime((String)stateJsonObject.get((Object)"updateTime"));
                        }
                        this.state = deviceState;
                    }
                    if (key.equals("logLevel") && value != null) {
                        this.logLevel = LogLevel.valueOf(value.toString());
                    }
                    if (key.equals("metadata") && (metadataJsonObject = (JSONObject)value) != null) {
                        HashMap<String, String> metadataMap = new HashMap<String, String>();
                        Set metadataSet = metadataJsonObject.keySet();
                        if (metadataSet.size() > 0) {
                            for (String metadataKey : metadataSet) {
                                String metatdataValue = (String)metadataJsonObject.get((Object)metadataKey);
                                metadataMap.put(metadataKey, metatdataValue);
                            }
                        }
                        this.metadata = metadataMap;
                    }
                    if (!key.equals("gatewayConfig") || (gatewayConfigJsonObject = (JSONObject)value) == null) continue;
                    GatewayConfig gatewayConfig = new GatewayConfig();
                    if (gatewayConfigJsonObject.containsKey((Object)"gatewayType")) {
                        gatewayConfig.setGatewayType(GatewayType.valueOf((String)gatewayConfigJsonObject.get((Object)"gatewayType")));
                    }
                    if (gatewayConfigJsonObject.containsKey((Object)"gatewayAuthMethod")) {
                        gatewayConfig.setGatewayAuthMethod(GatewayAuthMethod.valueOf((String)gatewayConfigJsonObject.get((Object)"gatewayAuthMethod")));
                    }
                    if (gatewayConfigJsonObject.containsKey((Object)"lastAccessedGatewayId")) {
                        gatewayConfig.setLastAccessedGatewayId((String)gatewayConfigJsonObject.get((Object)"lastAccessedGatewayId"));
                    }
                    if (gatewayConfigJsonObject.containsKey((Object)"lastAccessedGatewayTime")) {
                        gatewayConfig.setLastAccessedGatewayTime((String)gatewayConfigJsonObject.get((Object)"lastAccessedGatewayTime"));
                    }
                    this.gatewayConfig = gatewayConfig;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public static class Builder {
        private String id;
        private String name;
        private String numId;
        private List<DeviceCredential> credentials;
        private String lastHeartbeatTime;
        private String lastEventTime;
        private String lastStateTime;
        private String lastConfigAckTime;
        private String lastConfigSendTime;
        private boolean blocked;
        private String lastErrorTime;
        private Status lastErrorStatus;
        private DeviceConfig config;
        private DeviceState state;
        private LogLevel logLevel;
        private Map<String, String> metadata;
        private GatewayConfig gatewayConfig;

        protected Builder() {
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getNumId() {
            return this.numId;
        }

        public List<DeviceCredential> getCredentials() {
            return this.credentials;
        }

        public String getLastHeartbeatTime() {
            return this.lastHeartbeatTime;
        }

        public String getLastEventTime() {
            return this.lastEventTime;
        }

        public String getLastStateTime() {
            return this.lastStateTime;
        }

        public String getLastConfigAckTime() {
            return this.lastConfigAckTime;
        }

        public String getLastConfigSendTime() {
            return this.lastConfigSendTime;
        }

        public boolean isBlocked() {
            return this.blocked;
        }

        public String getLastErrorTime() {
            return this.lastErrorTime;
        }

        public Status getLastErrorStatus() {
            return this.lastErrorStatus;
        }

        public DeviceConfig getConfig() {
            return this.config;
        }

        public DeviceState getState() {
            return this.state;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        public GatewayConfig getGatewayConfig() {
            return this.gatewayConfig;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public static Builder newBuilder() {
            return Builder.newBuilder();
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setNumId(String numId) {
            this.numId = numId;
            return this;
        }

        public Builder setCredentials(List<DeviceCredential> credentials) {
            this.credentials = credentials;
            return this;
        }

        public Builder setLastErrorStatus(Status lastErrorStatus) {
            this.lastErrorStatus = lastErrorStatus;
            return this;
        }

        public Builder setConfig(DeviceConfig config) {
            this.config = config;
            return this;
        }

        public Builder setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setState(DeviceState state) {
            this.state = state;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setGatewayConfig(GatewayConfig gatewayConfig) {
            this.gatewayConfig = gatewayConfig;
            return this;
        }

        public Builder setBlocked(boolean blocked) {
            this.blocked = blocked;
            return this;
        }

        public Builder setLastHeartbeatTime(String lastHeartbeatTime) {
            this.lastHeartbeatTime = lastHeartbeatTime;
            return this;
        }

        public Builder setLastEventTime(String lastEventTime) {
            this.lastEventTime = lastEventTime;
            return this;
        }

        public Builder setLastStateTime(String lastStateTime) {
            this.lastStateTime = lastStateTime;
            return this;
        }

        public Builder setLastConfigAckTime(String lastConfigAckTime) {
            this.lastConfigAckTime = lastConfigAckTime;
            return this;
        }

        public Builder setLastConfigSendTime(String lastConfigSendTime) {
            this.lastConfigSendTime = lastConfigSendTime;
            return this;
        }

        public Builder setLastErrorTime(String lastErrorTime) {
            this.lastErrorTime = lastErrorTime;
            return this;
        }

        private Builder(Device device) {
            this.id = device.id;
            this.name = device.name;
            this.numId = device.numId;
            this.credentials = device.credentials;
            this.lastHeartbeatTime = device.lastHeartbeatTime;
            this.lastEventTime = device.lastEventTime;
            this.lastStateTime = device.lastStateTime;
            this.lastConfigAckTime = device.lastConfigAckTime;
            this.lastConfigSendTime = device.lastConfigSendTime;
            this.blocked = device.blocked;
            this.lastErrorTime = device.lastErrorTime;
            this.lastErrorStatus = device.lastErrorStatus;
            this.config = device.config;
            this.state = device.state;
            this.logLevel = device.logLevel;
            this.metadata = device.metadata;
            this.gatewayConfig = device.gatewayConfig;
        }

        public Device build() {
            return new Device(this);
        }
    }
}

