/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.devicetypes;

import com.clearblade.cloud.iot.v1.utils.ByteString;
import com.clearblade.cloud.iot.v1.utils.Timestamp;
import com.clearblade.cloud.iot.v1.utils.Utils;
import java.time.Instant;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class DeviceConfig {
    static Logger log = Logger.getLogger(DeviceConfig.class.getName());
    private String version;
    private Object cloudUpdateTime;
    private Object deviceAckTime;
    private Object binaryData;

    public DeviceConfig() {
    }

    private DeviceConfig(Builder builder) {
        this.version = builder.version;
        this.cloudUpdateTime = builder.cloudUpdateTime;
        this.deviceAckTime = builder.deviceAckTime;
        this.binaryData = builder.binaryData;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setCloudUpdateTime(String cloudUpdateTime) {
        this.cloudUpdateTime = cloudUpdateTime;
    }

    public void setDeviceAckTime(String deviceAckTime) {
        this.deviceAckTime = deviceAckTime;
    }

    public void setBinaryData(String binaryData) {
        this.binaryData = binaryData;
    }

    public String getVersion() {
        return this.version;
    }

    public Object getCloudUpdateTime() {
        if (Utils.isBinary()) {
            if (!Utils.isEmpty(this.cloudUpdateTime)) {
                Instant timeStamp = Instant.parse(this.cloudUpdateTime.toString());
                return new Timestamp(timeStamp.getEpochSecond(), timeStamp.getNano());
            }
            return new Timestamp(0L, 0);
        }
        return this.cloudUpdateTime != null ? this.cloudUpdateTime.toString() : "";
    }

    public Object getDeviceAckTime() {
        if (Utils.isBinary()) {
            if (!Utils.isEmpty(this.deviceAckTime)) {
                Instant timeStamp = Instant.parse(this.deviceAckTime.toString());
                return new Timestamp(timeStamp.getEpochSecond(), timeStamp.getNano());
            }
            return new Timestamp(0L, 0);
        }
        return this.deviceAckTime != null ? this.deviceAckTime.toString() : "";
    }

    public Object getBinaryData() {
        if (Utils.isBinary()) {
            return ByteString.copyFromUtf8(!Utils.isEmpty(this.binaryData) ? this.binaryData.toString() : "");
        }
        return this.binaryData != null ? this.binaryData.toString() : "";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void loadFromString(String jsonString) {
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject jsonObj = (JSONObject)jsonParser.parse(jsonString);
            this.version = (String)jsonObj.get((Object)"version");
            this.cloudUpdateTime = (String)jsonObj.get((Object)"cloudUpdateTime");
            this.deviceAckTime = (String)jsonObj.get((Object)"deviceAckTime");
            this.binaryData = (String)jsonObj.get((Object)"binaryData");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        if (this.getVersion() != null) {
            jsonObject.put((Object)"version", (Object)this.getVersion());
        }
        if (this.cloudUpdateTime != null) {
            jsonObject.put((Object)"cloudUpdateTime", (Object)this.cloudUpdateTime.toString());
        }
        if (this.deviceAckTime != null) {
            jsonObject.put((Object)"deviceAckTime", (Object)this.deviceAckTime.toString());
        }
        if (this.binaryData != null) {
            jsonObject.put((Object)"binaryData", (Object)this.binaryData.toString());
        }
        return jsonObject;
    }

    public static class Builder {
        private String version;
        private Object cloudUpdateTime;
        private Object deviceAckTime;
        private Object binaryData;

        protected Builder() {
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        public Object getCloudUpdateTime() {
            if (Utils.isBinary()) {
                if (!Utils.isEmpty(this.cloudUpdateTime)) {
                    Instant timeStamp = Instant.parse(this.cloudUpdateTime.toString());
                    return new Timestamp(timeStamp.getEpochSecond(), timeStamp.getNano());
                }
                return new Timestamp(0L, 0);
            }
            return this.cloudUpdateTime != null ? this.cloudUpdateTime.toString() : "";
        }

        public Builder setCloudUpdateTime(String cloudUpdateTime) {
            this.cloudUpdateTime = cloudUpdateTime;
            return this;
        }

        public Object getDeviceAckTime() {
            if (Utils.isBinary()) {
                if (!Utils.isEmpty(this.deviceAckTime)) {
                    Instant timeStamp = Instant.parse(this.deviceAckTime.toString());
                    return new Timestamp(timeStamp.getEpochSecond(), timeStamp.getNano());
                }
                return new Timestamp(0L, 0);
            }
            return this.deviceAckTime != null ? this.deviceAckTime.toString() : "";
        }

        public Builder setDeviceAckTime(String deviceAckTime) {
            this.deviceAckTime = deviceAckTime;
            return this;
        }

        public Object getBinaryData() {
            if (Utils.isBinary()) {
                return ByteString.copyFromUtf8(!Utils.isEmpty(this.binaryData) ? this.binaryData.toString() : "");
            }
            return this.binaryData != null ? this.binaryData.toString() : "";
        }

        public Builder setBinaryData(String binaryData) {
            this.binaryData = binaryData;
            return this;
        }

        private Builder(DeviceConfig deviceConfig) {
            this.version = deviceConfig.version;
            this.cloudUpdateTime = deviceConfig.cloudUpdateTime;
            this.deviceAckTime = deviceConfig.deviceAckTime;
            this.binaryData = deviceConfig.binaryData;
        }

        public DeviceConfig build() {
            return new DeviceConfig(this);
        }
    }
}

