/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.devicetypes;

import com.clearblade.cloud.iot.v1.registrytypes.PublicKeyCredential;
import com.clearblade.cloud.iot.v1.utils.Utils;
import org.json.simple.JSONObject;

public class DeviceCredential {
    private String expirationTime;
    private PublicKeyCredential publicKey;

    public DeviceCredential() {
    }

    private DeviceCredential(Builder builder) {
        this.expirationTime = builder.expirationTime;
        this.publicKey = builder.publicKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void setExpirationTime(String expirationTime) {
        this.expirationTime = expirationTime;
    }

    public void setPublicKey(PublicKeyCredential publicKey) {
        this.publicKey = publicKey;
    }

    public boolean isEmpty() {
        return this.publicKey == null;
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        if (!Utils.isEmpty(this.expirationTime)) {
            jsonObject.put((Object)"expirationTime", (Object)this.expirationTime);
        }
        jsonObject.put((Object)"publicKey", (Object)this.publicKey.toJSONObject());
        return jsonObject;
    }

    public static class Builder {
        private String expirationTime;
        private PublicKeyCredential publicKey;

        protected Builder() {
        }

        public String getExpirationTime() {
            return this.expirationTime;
        }

        public Builder setExpirationTime(String expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public PublicKeyCredential getPublicKey() {
            return this.publicKey;
        }

        public Builder setPublicKey(PublicKeyCredential publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        private Builder(DeviceCredential deviceCredential) {
            this.expirationTime = deviceCredential.expirationTime;
            this.publicKey = deviceCredential.publicKey;
        }

        public DeviceCredential build() {
            return new DeviceCredential(this);
        }
    }
}

