/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.devicetypes;

import com.clearblade.cloud.iot.v1.utils.PathTemplate;
import java.util.Map;

public class DeviceName {
    private static final PathTemplate PROJECT_LOCATION_REGISTRY_DEVICE = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/registries/{registry}/devices/{device}");
    private final String project;
    private final String location;
    private final String registry;
    private final String device;

    protected DeviceName() {
        this.project = null;
        this.location = null;
        this.registry = null;
        this.device = null;
    }

    private DeviceName(Builder builder) {
        this.project = builder.getProject();
        this.location = builder.getLocation();
        this.registry = builder.getRegistry();
        this.device = builder.getDevice();
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getDevice() {
        return this.device;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceName of(String project, String location, String registry, String device) {
        return DeviceName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).setDevice(device).build();
    }

    public static String format(String project, String location, String registry, String device) {
        return DeviceName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).setDevice(device).build().toString();
    }

    public static DeviceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION_REGISTRY_DEVICE.validatedMatch(formattedString, "DeviceName.parse: formattedString not in valid format");
        return DeviceName.of(matchMap.get("project"), matchMap.get("location"), matchMap.get("registry"), matchMap.get("device"));
    }

    public String toString() {
        return PROJECT_LOCATION_REGISTRY_DEVICE.instantiate("project", this.project, "location", this.location, "registry", this.registry, "device", this.device);
    }

    public static class Builder {
        private String project;
        private String location;
        private String registry;
        private String device;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRegistry() {
            return this.registry;
        }

        public String getDevice() {
            return this.device;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRegistry(String registry) {
            this.registry = registry;
            return this;
        }

        public Builder setDevice(String device) {
            this.device = device;
            return this;
        }

        private Builder(DeviceName deviceName) {
            this.project = deviceName.project;
            this.location = deviceName.location;
            this.registry = deviceName.registry;
            this.device = deviceName.device;
        }

        public DeviceName build() {
            return new DeviceName(this);
        }
    }
}

