/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.devicetypes;

import com.clearblade.cloud.iot.v1.utils.ByteString;
import com.clearblade.cloud.iot.v1.utils.Timestamp;
import com.clearblade.cloud.iot.v1.utils.Utils;
import java.time.Instant;
import org.json.simple.JSONObject;

public class DeviceState {
    private Object updateTime;
    private Object binaryData;

    public DeviceState(Builder builder) {
        this.updateTime = builder.updateTime;
        this.binaryData = builder.getBinaryData();
    }

    public DeviceState() {
    }

    public Object getBinaryData() {
        if (Utils.isBinary()) {
            return ByteString.copyFromUtf8(!Utils.isEmpty(this.binaryData) ? this.binaryData.toString() : "");
        }
        return this.binaryData != null ? this.binaryData.toString() : "";
    }

    public Object getUpdateTime() {
        if (Utils.isBinary()) {
            if (!Utils.isEmpty(this.updateTime)) {
                Instant timeStamp = Instant.parse(this.updateTime.toString());
                return new Timestamp(timeStamp.getEpochSecond(), timeStamp.getNano());
            }
            return new Timestamp(0L, 0);
        }
        return this.updateTime != null ? this.updateTime.toString() : "";
    }

    public void setUpdateTime(Object updateTime) {
        this.updateTime = updateTime;
    }

    public void setBinaryData(Object binaryData) {
        this.binaryData = binaryData;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public JSONObject toJSONObject() {
        JSONObject jsonObject = new JSONObject();
        if (this.getUpdateTime() != null) {
            jsonObject.put((Object)"updateTime", (Object)this.updateTime.toString());
        } else {
            jsonObject.put((Object)"updateTime", (Object)"");
        }
        if (this.getBinaryData() != null) {
            jsonObject.put((Object)"binaryData", (Object)this.binaryData.toString());
        } else {
            jsonObject.put((Object)"binaryData", (Object)"");
        }
        return jsonObject;
    }

    public static class Builder {
        private Object binaryData;
        private Object updateTime;

        protected Builder() {
        }

        public Object getUpdateTime() {
            if (Utils.isBinary()) {
                if (!Utils.isEmpty(this.updateTime)) {
                    Instant timeStamp = Instant.parse(this.updateTime.toString());
                    return new Timestamp(timeStamp.getEpochSecond(), timeStamp.getNano());
                }
                return new Timestamp(0L, 0);
            }
            return this.updateTime != null ? this.updateTime.toString() : "";
        }

        public Builder setUpdateTime(String updateTime) {
            this.updateTime = updateTime.toString();
            return this;
        }

        public Object getBinaryDataByte() {
            return this.binaryData;
        }

        public Object getBinaryData() {
            if (Utils.isBinary()) {
                return ByteString.copyFromUtf8(!Utils.isEmpty(this.binaryData) ? this.binaryData.toString() : "");
            }
            return this.binaryData != null ? this.binaryData.toString() : "";
        }

        public Builder setBinaryData(String binaryData) {
            this.binaryData = binaryData.toString();
            return this;
        }

        private Builder(DeviceState deviceState) {
            this.updateTime = deviceState.updateTime;
            this.binaryData = deviceState.binaryData;
        }

        public DeviceState build() {
            return new DeviceState(this);
        }
    }
}

