/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.listdeviceconfigversions;

import com.clearblade.cloud.iot.v1.devicetypes.DeviceConfig;
import com.clearblade.cloud.iot.v1.listdeviceconfigversions.ListDeviceConfigVersionsRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ListDeviceConfigVersionsResponse {
    static Logger log = Logger.getLogger(ListDeviceConfigVersionsResponse.class.getName());
    private List<DeviceConfig> deviceConfigList = new ArrayList<DeviceConfig>();

    protected ListDeviceConfigVersionsResponse(Builder builder) {
        this.deviceConfigList = builder.deviceConfigList;
    }

    public List<DeviceConfig> getDeviceConfigList() {
        return this.deviceConfigList;
    }

    public void setDeviceConfigList(List<DeviceConfig> deviceConfigList) {
        this.deviceConfigList = deviceConfigList;
    }

    public static class Builder {
        private List<DeviceConfig> deviceConfigList = new ArrayList<DeviceConfig>();

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setDeviceConfigVersionsListRequest(ListDeviceConfigVersionsRequest request) {
            return this;
        }

        public Builder buildResponse(String configList) {
            try {
                JSONObject jsonObj = new JSONObject();
                JSONParser jsonParser = new JSONParser();
                jsonObj = (JSONObject)jsonParser.parse(configList);
                JSONArray configArray = (JSONArray)jsonObj.get((Object)"deviceConfigs");
                for (JSONObject configJson : configArray) {
                    DeviceConfig configObj = DeviceConfig.newBuilder().setBinaryData((String)configJson.get((Object)"binaryData")).setCloudUpdateTime((String)configJson.get((Object)"cloudUpdateTime")).setDeviceAckTime((String)configJson.get((Object)"deviceAckTime")).setVersion((String)configJson.get((Object)"version")).build();
                    this.deviceConfigList.add(configObj);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage());
            }
            return this;
        }

        public ListDeviceConfigVersionsResponse build() {
            return new ListDeviceConfigVersionsResponse(this);
        }
    }
}

