/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.listdeviceregistries;

import com.clearblade.cloud.iot.v1.registrytypes.DeviceRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ListDeviceRegistriesResponse {
    static Logger log = Logger.getLogger(ListDeviceRegistriesResponse.class.getName());
    private String nextPageToken;
    private List<DeviceRegistry> deviceRegistriesList;

    protected ListDeviceRegistriesResponse(Builder builder) {
        this.deviceRegistriesList = builder.deviceRegistriesList;
        this.nextPageToken = builder.nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public List<DeviceRegistry> getDeviceRegistriesList() {
        return this.deviceRegistriesList;
    }

    public void setDeviceRegistriesList(List<DeviceRegistry> deviceRegistriesList) {
        this.deviceRegistriesList = deviceRegistriesList;
    }

    public static class Builder {
        private String nextPageToken;
        private List<DeviceRegistry> deviceRegistriesList = new ArrayList<DeviceRegistry>();

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder buildResponse(String jsonString) {
            try {
                JSONObject jsonObj = new JSONObject();
                JSONParser jsonParser = new JSONParser();
                jsonObj = (JSONObject)jsonParser.parse(jsonString);
                JSONArray deviceRegistriesArray = (JSONArray)jsonObj.get((Object)"deviceRegistries");
                for (JSONObject deviceRegistryJson : deviceRegistriesArray) {
                    DeviceRegistry deviceRegistryObj = DeviceRegistry.newBuilder().build();
                    deviceRegistryObj.loadFromString(deviceRegistryJson.toString());
                    this.deviceRegistriesList.add(deviceRegistryObj);
                }
                if (jsonObj.containsKey((Object)"nextPageToken")) {
                    this.nextPageToken = jsonObj.get((Object)"nextPageToken").toString();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage());
            }
            return this;
        }

        public ListDeviceRegistriesResponse build() {
            return new ListDeviceRegistriesResponse(this);
        }
    }
}

