/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.modifycloudtodeviceconfig;

import com.clearblade.cloud.iot.v1.devicetypes.DeviceName;
import com.clearblade.cloud.iot.v1.utils.ByteString;
import java.util.Arrays;
import org.json.simple.JSONObject;

public class ModifyCloudToDeviceConfigRequest {
    private String deviceName;
    private String versionToUpdate;
    private ByteString binaryData;
    private byte[] binaryDataByte;

    private ModifyCloudToDeviceConfigRequest(Builder builder) {
        this.deviceName = builder.deviceName;
        this.versionToUpdate = builder.versionToUpdate;
        this.binaryData = builder.binaryData;
        this.binaryDataByte = builder.binaryDataByte;
    }

    public DeviceName getDeviceName() {
        return DeviceName.parse(this.deviceName);
    }

    public String toString() {
        return "name = " + this.deviceName + ", versionToUpdate = " + this.versionToUpdate;
    }

    public String[] getBodyAndParams() {
        String[] output = new String[2];
        String params = "name=" + this.deviceName + "&method=modifyCloudToDeviceConfig";
        String bData = "EMPTY";
        if (this.binaryData != null) {
            bData = new String(this.binaryData.toByteArray());
        } else if (this.binaryDataByte != null) {
            bData = this.binaryDataByte.length == 0 ? "EMPTY" : Arrays.toString(this.binaryDataByte);
        }
        JSONObject bodyParams = new JSONObject();
        bodyParams.put((Object)"binaryData", (Object)bData);
        bodyParams.put((Object)"versionToUpdate", (Object)this.versionToUpdate);
        output[0] = params;
        output[1] = bodyParams.toJSONString();
        return output;
    }

    public static class Builder {
        private String deviceName;
        private String versionToUpdate;
        private ByteString binaryData;
        private byte[] binaryDataByte;

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public Builder setVersionToUpdate(String versionToUpdate) {
            this.versionToUpdate = versionToUpdate;
            return this;
        }

        public Builder setBinaryData(ByteString binaryData) {
            this.binaryData = binaryData;
            return this;
        }

        public Builder setBinaryData(byte[] binaryDataByte) {
            this.binaryDataByte = binaryDataByte;
            return this;
        }

        public ModifyCloudToDeviceConfigRequest build() {
            return new ModifyCloudToDeviceConfigRequest(this);
        }
    }
}

