/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.registrytypes;

import com.clearblade.cloud.iot.v1.registrytypes.EventNotificationConfig;
import com.clearblade.cloud.iot.v1.registrytypes.HttpConfig;
import com.clearblade.cloud.iot.v1.registrytypes.HttpState;
import com.clearblade.cloud.iot.v1.registrytypes.MqttConfig;
import com.clearblade.cloud.iot.v1.registrytypes.MqttState;
import com.clearblade.cloud.iot.v1.registrytypes.RegistryCredential;
import com.clearblade.cloud.iot.v1.registrytypes.StateNotificationConfig;
import com.clearblade.cloud.iot.v1.utils.LogLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class DeviceRegistry {
    static Logger log = Logger.getLogger(DeviceRegistry.class.getName());
    private String id;
    private String name;
    private List<EventNotificationConfig> eventNotificationConfigs;
    private StateNotificationConfig stateNotificationConfig;
    private MqttConfig mqttConfig;
    private HttpConfig httpConfig;
    private LogLevel logLevel;
    private List<RegistryCredential> credentials;

    public DeviceRegistry() {
        this.id = "";
        this.name = "";
        this.eventNotificationConfigs = new ArrayList<EventNotificationConfig>();
        this.stateNotificationConfig = null;
        this.mqttConfig = null;
        this.httpConfig = null;
        this.logLevel = null;
        this.credentials = new ArrayList<RegistryCredential>();
    }

    private DeviceRegistry(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.eventNotificationConfigs = builder.getEventNotificationConfigs();
        this.stateNotificationConfig = builder.getStateNotificationConfig();
        this.mqttConfig = builder.getMqttConfig();
        this.httpConfig = builder.getHttpConfig();
        this.logLevel = builder.getLogLevel();
        this.credentials = builder.getCredentials();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static DeviceRegistry of(String id, String name, List<EventNotificationConfig> eventNotificationConfigs, StateNotificationConfig stateNotificationConfig, MqttConfig mqttConfig, HttpConfig httpConfig, LogLevel logLevel, List<RegistryCredential> credentials) {
        return DeviceRegistry.newBuilder().setId(id).setName(name).setEventNotificationConfigs(eventNotificationConfigs).setStateNotificationConfig(stateNotificationConfig).setMqttConfig(mqttConfig).setHttpConfig(httpConfig).setLogLevel(logLevel).setCredentials(credentials).build();
    }

    public static String format(String id, String name, List<EventNotificationConfig> eventNotificationConfigs, StateNotificationConfig stateNotificationConfig, MqttConfig mqttConfig, HttpConfig httpConfig, LogLevel logLevel, List<RegistryCredential> credentials) {
        return DeviceRegistry.newBuilder().setId(id).setName(name).setEventNotificationConfigs(eventNotificationConfigs).setStateNotificationConfig(stateNotificationConfig).setMqttConfig(mqttConfig).setHttpConfig(httpConfig).setLogLevel(logLevel).setCredentials(credentials).build().toString();
    }

    public String toString() {
        return "id=" + this.id + ",name=" + this.name + ",eventNotificationConfigs=" + this.eventNotificationConfigs + ",stateNotificationConfig=" + this.stateNotificationConfig + "mqttConfig=" + this.mqttConfig.toBuilder().build() + ",httpConfig=" + this.httpConfig + ",logLevel=" + this.logLevel + ",credentials=" + this.credentials;
    }

    public String createDeviceJSONObject(String parentLocation) {
        int i;
        JSONObject json;
        JSONObject output = new JSONObject();
        if (this.id != null) {
            output.put((Object)"id", (Object)this.id);
        }
        if (this.name != null) {
            if (!this.name.startsWith("projects")) {
                this.name = parentLocation + "/registries/" + this.name;
            }
            output.put((Object)"name", (Object)this.name);
        }
        if (this.logLevel != null) {
            output.put((Object)"logLevel", (Object)this.logLevel.name());
        }
        if (this.httpConfig != null) {
            output.put((Object)"httpConfig", (Object)this.httpConfig.getJsonObject());
        } else {
            json = new JSONObject();
            json.put((Object)"httpEnabledState", (Object)"HTTP_ENABLED");
            output.put((Object)"httpConfig", (Object)json);
        }
        if (this.mqttConfig != null) {
            output.put((Object)"mqttConfig", (Object)this.mqttConfig.getJsonObject());
        } else {
            json = new JSONObject();
            json.put((Object)"mqttEnabledState", (Object)"MQTT_ENABLED");
            output.put((Object)"mqttConfig", (Object)json);
        }
        if (this.stateNotificationConfig != null) {
            output.put((Object)"stateNotificationConfig", (Object)this.stateNotificationConfig.getJsonObject());
        } else {
            json = new JSONObject();
            json.put((Object)"pubsubTopicName", (Object)"");
            output.put((Object)"stateNotificationConfig", (Object)json);
        }
        if (this.eventNotificationConfigs != null) {
            JSONArray eventsArray = new JSONArray();
            for (i = 0; i < this.eventNotificationConfigs.size(); ++i) {
                eventsArray.add((Object)this.eventNotificationConfigs.get(i).getJsonObject());
            }
            output.put((Object)"eventNotificationConfigs", (Object)eventsArray);
        }
        if (this.credentials != null) {
            JSONArray credentialArray = new JSONArray();
            for (i = 0; i < this.credentials.size(); ++i) {
                credentialArray.add((Object)this.credentials.get(i).getJsonObject());
            }
            output.put((Object)"credentials", (Object)credentialArray);
        }
        return output.toJSONString();
    }

    public void loadFromString(String inputStr) {
        try {
            JSONParser parser = new JSONParser();
            JSONObject deviceObj = (JSONObject)parser.parse(inputStr);
            if (deviceObj != null && deviceObj.size() > 0) {
                Set deviceSet = deviceObj.keySet();
                for (String key : deviceSet) {
                    JSONArray credJsonArray;
                    Object value = deviceObj.get((Object)key);
                    if (key.equals("id")) {
                        this.id = value.toString();
                    }
                    if (key.equals("name")) {
                        this.name = value.toString();
                    }
                    if (key.equals("eventNotificationConfigs")) {
                        JSONArray eventJsonArray = (JSONArray)value;
                        ArrayList<EventNotificationConfig> eventNotificationCfgs = new ArrayList<EventNotificationConfig>();
                        for (JSONObject eventJson : eventJsonArray) {
                            EventNotificationConfig eventObj = EventNotificationConfig.newBuilder().setSubfolderMatches((String)eventJson.get((Object)"subfolderMatches")).setPubsubTopicName((String)eventJson.get((Object)"pubsubTopicName")).build();
                            eventNotificationCfgs.add(eventObj);
                        }
                        this.eventNotificationConfigs = eventNotificationCfgs;
                    }
                    if (key.equals("stateNotificationConfig")) {
                        JSONObject stateJsonObject = (JSONObject)value;
                        StateNotificationConfig stateNotificationCfg = new StateNotificationConfig();
                        if (stateJsonObject.containsKey((Object)"pubsubTopicName")) {
                            stateNotificationCfg.setPubsubTopicName((String)stateJsonObject.get((Object)"pubsubTopicName"));
                        }
                        this.stateNotificationConfig = stateNotificationCfg;
                    }
                    if (key.equals("mqttConfig")) {
                        JSONObject mqttJsonObject = (JSONObject)value;
                        MqttConfig mqttCfg = new MqttConfig();
                        if (mqttJsonObject.containsKey((Object)"mqttEnabledState")) {
                            mqttCfg.setMqttEnabledState(MqttState.valueOf((String)mqttJsonObject.get((Object)"mqttEnabledState")));
                        }
                        this.mqttConfig = mqttCfg;
                    }
                    if (key.equals("httpConfig")) {
                        JSONObject httpJsonObject = (JSONObject)value;
                        HttpConfig httpCfg = new HttpConfig();
                        if (httpJsonObject.containsKey((Object)"httpEnabledState")) {
                            httpCfg.setHttpEnabledState(HttpState.valueOf((String)httpJsonObject.get((Object)"httpEnabledState")));
                        }
                        this.httpConfig = httpCfg;
                    }
                    if (key.equals("logLevel") && value != null) {
                        this.logLevel = LogLevel.valueOf(value.toString());
                    }
                    if (!key.equals("credentials") || (credJsonArray = (JSONArray)value) == null) continue;
                    ArrayList<RegistryCredential> registryCredentialsArray = new ArrayList<RegistryCredential>();
                    for (JSONObject credJson : credJsonArray) {
                        RegistryCredential registryCredential = RegistryCredential.newBuilder().build();
                        registryCredential.loadFromJson(credJson);
                        registryCredentialsArray.add(registryCredential);
                    }
                    this.credentials = registryCredentialsArray;
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public static class Builder {
        private String id;
        private String name;
        private List<EventNotificationConfig> eventNotificationConfigs;
        private StateNotificationConfig stateNotificationConfig;
        private MqttConfig mqttConfig;
        private HttpConfig httpConfig;
        private LogLevel logLevel;
        private List<RegistryCredential> credentials;

        protected Builder() {
        }

        public static Builder newBuilder() {
            return Builder.newBuilder();
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<EventNotificationConfig> getEventNotificationConfigs() {
            return this.eventNotificationConfigs;
        }

        public StateNotificationConfig getStateNotificationConfig() {
            return this.stateNotificationConfig;
        }

        public MqttConfig getMqttConfig() {
            return this.mqttConfig;
        }

        public HttpConfig getHttpConfig() {
            return this.httpConfig;
        }

        public LogLevel getLogLevel() {
            return this.logLevel;
        }

        public List<RegistryCredential> getCredentials() {
            return this.credentials;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEventNotificationConfigs(List<EventNotificationConfig> eventNotificationConfigs) {
            this.eventNotificationConfigs = eventNotificationConfigs;
            return this;
        }

        public Builder setStateNotificationConfig(StateNotificationConfig stateNotificationConfig) {
            this.stateNotificationConfig = stateNotificationConfig;
            return this;
        }

        public Builder setMqttConfig(MqttConfig mqttConfig) {
            this.mqttConfig = mqttConfig;
            return this;
        }

        public Builder setHttpConfig(HttpConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public Builder setLogLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder setCredentials(List<RegistryCredential> credentials) {
            this.credentials = credentials;
            return this;
        }

        private Builder(DeviceRegistry registry) {
            this.id = registry.id;
            this.name = registry.name;
            this.eventNotificationConfigs = registry.eventNotificationConfigs;
            this.stateNotificationConfig = registry.stateNotificationConfig;
            this.mqttConfig = registry.mqttConfig;
            this.httpConfig = registry.httpConfig;
            this.logLevel = registry.logLevel;
            this.credentials = registry.credentials;
        }

        public DeviceRegistry build() {
            return new DeviceRegistry(this);
        }
    }
}

