/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.registrytypes;

import com.clearblade.cloud.iot.v1.utils.PathTemplate;
import java.util.Map;

public class LocationName {
    private static final PathTemplate PROJECT_LOCATION = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}");
    private final String project;
    private final String location;

    protected LocationName() {
        this.project = null;
        this.location = null;
    }

    private LocationName(Builder builder) {
        this.project = builder.getProject();
        this.location = builder.getLocation();
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LocationName of(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build();
    }

    public static String format(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build().toString();
    }

    public static LocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION.validatedMatch(formattedString, "LocationName.parse: formattedString not in valid format");
        return LocationName.of(matchMap.get("project"), matchMap.get("location"));
    }

    public String toString() {
        return PROJECT_LOCATION.instantiate("project", this.project, "location", this.location);
    }

    public String getLocationFullName() {
        return PROJECT_LOCATION.instantiate("project", this.project, "location", this.location);
    }

    public static class Builder {
        private String project;
        private String location;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder(LocationName locationName) {
            this.project = locationName.project;
            this.location = locationName.location;
        }

        public LocationName build() {
            return new LocationName(this);
        }
    }
}

