/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.registrytypes;

import com.clearblade.cloud.iot.v1.registrytypes.PublicKeyCertificate;
import com.clearblade.cloud.iot.v1.registrytypes.PublicKeyCertificateFormat;
import com.clearblade.cloud.iot.v1.registrytypes.X509CertificateDetails;
import org.json.simple.JSONObject;

public class RegistryCredential {
    private PublicKeyCertificate publicKeyCertificate;

    public RegistryCredential() {
        this.publicKeyCertificate = null;
    }

    private RegistryCredential(Builder builder) {
        this.publicKeyCertificate = builder.getPublicKeyCertificate();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "PublicKeyCertificate=" + this.publicKeyCertificate.toString();
    }

    public void loadFromJson(JSONObject jsonObject) {
        if (jsonObject.containsKey((Object)"publicKeyCertificate")) {
            PublicKeyCertificate publicKeyCertificateObj = new PublicKeyCertificate();
            JSONObject publicKeyCertificateJson = (JSONObject)jsonObject.get((Object)"publicKeyCertificate");
            if (publicKeyCertificateJson.containsKey((Object)"format")) {
                publicKeyCertificateObj.setFormat(PublicKeyCertificateFormat.valueOf((String)publicKeyCertificateJson.get((Object)"format")));
            }
            if (publicKeyCertificateJson.containsKey((Object)"certificate")) {
                publicKeyCertificateObj.setCertificate((String)publicKeyCertificateJson.get((Object)"certificate"));
            }
            if (publicKeyCertificateJson.containsKey((Object)"x509Details")) {
                JSONObject x509DJsonObject = (JSONObject)publicKeyCertificateJson.get((Object)"x509Details");
                X509CertificateDetails x509CertificateDetails = new X509CertificateDetails();
                x509CertificateDetails.setIssuer((String)x509DJsonObject.get((Object)"issuer"));
                x509CertificateDetails.setSubject((String)x509DJsonObject.get((Object)"subject"));
                x509CertificateDetails.setStartTime((String)x509DJsonObject.get((Object)"startTime"));
                x509CertificateDetails.setExpiryTime((String)x509DJsonObject.get((Object)"expiryTime"));
                x509CertificateDetails.setSignatureAlgorithm((String)x509DJsonObject.get((Object)"signatureAlgorithm"));
                x509CertificateDetails.setPublicKeyType((String)x509DJsonObject.get((Object)"publicKeyType"));
                publicKeyCertificateObj.setX509Details(x509CertificateDetails);
            }
            this.publicKeyCertificate = publicKeyCertificateObj;
        }
    }

    public JSONObject getJsonObject() {
        JSONObject json = new JSONObject();
        JSONObject publicKeyCertificateJson = new JSONObject();
        if (this.publicKeyCertificate.getFormat() != null) {
            publicKeyCertificateJson.put((Object)"format", (Object)this.publicKeyCertificate.getFormat().name());
        }
        if (this.publicKeyCertificate.getCertificate() != null) {
            publicKeyCertificateJson.put((Object)"certificate", (Object)this.publicKeyCertificate.getCertificate());
        }
        if (this.publicKeyCertificate.getX509Details() != null) {
            X509CertificateDetails x509CertificateDetails = this.publicKeyCertificate.getX509Details();
            JSONObject x509DJsonObject = new JSONObject();
            x509DJsonObject.put((Object)"issuer", (Object)x509CertificateDetails.getIssuer());
            x509DJsonObject.put((Object)"subject", (Object)x509CertificateDetails.getSubject());
            x509DJsonObject.put((Object)"startTime", (Object)x509CertificateDetails.getStartTime());
            x509DJsonObject.put((Object)"expiryTime", (Object)x509CertificateDetails.getExpiryTime());
            x509DJsonObject.put((Object)"signatureAlgorithm", (Object)x509CertificateDetails.getSignatureAlgorithm());
            x509DJsonObject.put((Object)"publicKeyType", (Object)x509CertificateDetails.getPublicKeyType());
            publicKeyCertificateJson.put((Object)"x509Details", (Object)x509DJsonObject);
        }
        json.put((Object)"publicKeyCertificate", (Object)publicKeyCertificateJson);
        return json;
    }

    public static class Builder {
        private PublicKeyCertificate publicKeyCertificate;

        protected Builder() {
        }

        public PublicKeyCertificate getPublicKeyCertificate() {
            return this.publicKeyCertificate;
        }

        public Builder setPublicKeyCertificate(PublicKeyCertificate publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        private Builder(RegistryCredential registryCredential) {
            this.publicKeyCertificate = registryCredential.publicKeyCertificate;
        }

        public RegistryCredential build() {
            return new RegistryCredential(this);
        }
    }
}

