/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.registrytypes;

import com.clearblade.cloud.iot.v1.utils.PathTemplate;
import java.util.Map;

public class RegistryName {
    private static final PathTemplate PROJECT_LOCATION_REGISTRY = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/registries/{registry}");
    private final String project;
    private final String location;
    private final String registry;

    protected RegistryName() {
        this.project = null;
        this.location = null;
        this.registry = null;
    }

    private RegistryName(Builder builder) {
        this.project = builder.getProject();
        this.location = builder.getLocation();
        this.registry = builder.getRegistry();
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRegistry() {
        return this.registry;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RegistryName of(String project, String location, String registry) {
        return RegistryName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).build();
    }

    public static String format(String project, String location, String registry) {
        return RegistryName.newBuilder().setProject(project).setLocation(location).setRegistry(registry).build().toString();
    }

    public String toString() {
        return PROJECT_LOCATION_REGISTRY.instantiate("project", this.project, "location", this.location, "registry", this.registry);
    }

    public static RegistryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION_REGISTRY.validatedMatch(formattedString, "RegistryName.parse: formattedString not in valid format");
        return RegistryName.of(matchMap.get("project"), matchMap.get("location"), matchMap.get("registry"));
    }

    public String getRegistryFullName() {
        return PROJECT_LOCATION_REGISTRY.instantiate("project", this.project, "location", this.location, "registry", this.registry);
    }

    public static class Builder {
        private String project;
        private String location;
        private String registry;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRegistry() {
            return this.registry;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRegistry(String registry) {
            this.registry = registry;
            return this;
        }

        private Builder(RegistryName registryName) {
            this.project = registryName.project;
            this.location = registryName.location;
            this.registry = registryName.registry;
        }

        public RegistryName build() {
            return new RegistryName(this);
        }
    }
}

