/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.sendcommandtodevice;

import com.clearblade.cloud.iot.v1.devicetypes.DeviceName;
import com.clearblade.cloud.iot.v1.utils.ByteString;
import java.util.Arrays;
import org.json.simple.JSONObject;

public class SendCommandToDeviceRequest {
    private final DeviceName name;
    private final ByteString binaryData;
    private final byte[] binaryDataByte;
    private final String subfolder;
    private final String deviceName;
    public JSONObject requestParams;
    public JSONObject bodyParams;

    private SendCommandToDeviceRequest(Builder builder) {
        this.name = builder.name;
        this.binaryData = builder.binaryData;
        this.subfolder = builder.subfolder;
        this.binaryDataByte = builder.binaryDataByte;
        this.deviceName = builder.deviceName;
    }

    public DeviceName getDeviceName() {
        if (this.name != null) {
            return this.name;
        }
        return DeviceName.parse(this.deviceName);
    }

    public String toString() {
        this.requestParams = new JSONObject();
        this.bodyParams = new JSONObject();
        String dName = "";
        String bData = null;
        if (this.name != null) {
            dName = this.name.getDevice();
        } else if (this.deviceName != null) {
            dName = this.deviceName;
        }
        if (this.binaryData != null) {
            bData = new String(this.binaryData.toByteArray());
        } else if (this.binaryDataByte != null) {
            bData = this.binaryDataByte.length == 0 ? "EMPTY" : Arrays.toString(this.binaryDataByte);
        }
        this.requestParams.put((Object)"name", (Object)dName);
        this.bodyParams.put((Object)"binaryData", (Object)bData);
        this.bodyParams.put((Object)"subfolder", (Object)this.subfolder);
        return "name = " + dName + ", binaryData = " + bData + ", subfolder = " + this.subfolder;
    }

    public String[] getBodyAndParams() {
        String[] output = new String[2];
        String params = "name=" + this.deviceName + "&method=sendCommandToDevice";
        String bData = null;
        if (this.binaryData != null) {
            bData = new String(this.binaryData.toByteArray());
        } else if (this.binaryDataByte != null) {
            bData = this.binaryDataByte.length == 0 ? "EMPTY" : Arrays.toString(this.binaryDataByte);
        }
        this.bodyParams = new JSONObject();
        this.bodyParams.put((Object)"binaryData", (Object)bData);
        if (this.subfolder != null) {
            this.bodyParams.put((Object)"subfolder", (Object)this.subfolder);
        }
        output[0] = params;
        output[1] = this.bodyParams.toJSONString();
        return output;
    }

    public static class Builder {
        private DeviceName name;
        private ByteString binaryData;
        private String subfolder;
        private byte[] binaryDataByte;
        private String deviceName;

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setName(DeviceName name) {
            this.name = name;
            return this;
        }

        public Builder setBinaryData(ByteString binaryData) {
            this.binaryData = binaryData;
            return this;
        }

        public Builder setBinaryDataByte(byte[] binaryDataByte) {
            this.binaryDataByte = binaryDataByte;
            return this;
        }

        public Builder setSubfolder(String subfolder) {
            this.subfolder = subfolder;
            return this;
        }

        public Builder setName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public SendCommandToDeviceRequest build() {
            return new SendCommandToDeviceRequest(this);
        }
    }
}

