/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.updatedevice;

import com.clearblade.cloud.iot.v1.devicetypes.Device;
import com.clearblade.cloud.iot.v1.devicetypes.DeviceCredential;
import com.clearblade.cloud.iot.v1.devicetypes.DeviceName;
import java.util.Iterator;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class UpdateDeviceRequest {
    private final String name;
    private final Device device;
    private final String updateMask;
    JSONObject requestParams;
    JSONObject bodyParams;

    private UpdateDeviceRequest(Builder builder) {
        this.name = builder.name;
        this.updateMask = builder.updateMask;
        this.device = builder.device;
    }

    public JSONObject getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(JSONObject requestParams) {
        this.requestParams = requestParams;
    }

    public JSONObject getBodyParams() {
        return this.bodyParams;
    }

    public void setBodyParams(JSONObject bodyParams) {
        this.bodyParams = bodyParams;
    }

    public String toString() {
        this.requestParams.put((Object)"name", (Object)this.name);
        this.requestParams.put((Object)"updateMask", (Object)this.updateMask);
        this.bodyParams.put((Object)"id", (Object)this.device.toBuilder().getId());
        this.bodyParams.put((Object)"name", (Object)this.device.toBuilder().getName());
        this.bodyParams.put((Object)"logLevel", (Object)this.device.toBuilder().getLogLevel());
        this.bodyParams.put((Object)"blocked", (Object)this.device.toBuilder().isBlocked());
        return "name=" + this.name + ",updateMask=" + this.updateMask + ", logLevel= " + this.device.toBuilder().getLogLevel();
    }

    public DeviceName getDeviceName() {
        return DeviceName.parse(this.name);
    }

    public String[] getBodyAndParams() {
        String[] output = new String[2];
        String params = "name=" + this.name + "&updateMask=" + this.updateMask;
        this.bodyParams = new JSONObject();
        this.bodyParams.put((Object)"id", (Object)this.device.toBuilder().getId());
        this.bodyParams.put((Object)"name", (Object)this.device.toBuilder().getName());
        if (this.device.toBuilder().getLogLevel() != null) {
            this.bodyParams.put((Object)"logLevel", (Object)this.device.toBuilder().getLogLevel().toString());
        }
        this.bodyParams.put((Object)"blocked", (Object)this.device.toBuilder().isBlocked());
        if (this.device.toBuilder().getCredentials() != null && this.device.toBuilder().getCredentials().size() > 0) {
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < this.device.toBuilder().getCredentials().size(); ++i) {
                if (this.device.toBuilder().getCredentials().get(i).isEmpty()) continue;
                DeviceCredential credentialObj = this.device.toBuilder().getCredentials().get(i);
                jsonArray.add((Object)credentialObj.toJSONObject());
            }
            this.bodyParams.put((Object)"credentials", (Object)jsonArray);
        }
        if (this.device.toBuilder().getMetadata() != null && this.device.toBuilder().getMetadata().size() > 0) {
            Set<String> metaSet = this.device.toBuilder().getMetadata().keySet();
            Iterator<String> itr = metaSet.iterator();
            JSONObject jsonObject = new JSONObject();
            while (itr.hasNext()) {
                String key = itr.next();
                String value = this.device.toBuilder().getMetadata().get(key).toString();
                jsonObject.put((Object)key, (Object)value);
            }
            this.bodyParams.put((Object)"metadata", (Object)jsonObject);
        }
        output[0] = params;
        output[1] = this.bodyParams.toString();
        return output;
    }

    public static class Builder {
        private String name;
        private Device device;
        private String updateMask;

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDevice(Device device) {
            this.device = device;
            return this;
        }

        public Builder setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
        }

        public UpdateDeviceRequest build() {
            return new UpdateDeviceRequest(this);
        }
    }
}

