/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.utils;

import com.clearblade.cloud.iot.v1.exception.ApplicationException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class AuthParams {
    static Logger log = Logger.getLogger(AuthParams.class.getName());
    private static HashMap<String, String> cachedResponse = new HashMap();
    private String adminSystemKey = null;
    private String project = null;
    private String baseURL = null;
    private String adminToken = null;
    private String userSystemKey = null;
    private String userToken = null;
    private String apiBaseURL = null;

    public String getAdminSystemKey() {
        return this.adminSystemKey;
    }

    public String getProject() {
        return this.project;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getAdminToken() {
        return this.adminToken;
    }

    public String getUserSystemKey() {
        return this.userSystemKey;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getApiBaseURL() {
        return this.apiBaseURL;
    }

    public void setAdminCredentials() throws ApplicationException, IOException {
        block6: {
            try {
                String pathToAuthFile = System.getenv("CLEARBLADE_CONFIGURATION");
                if (pathToAuthFile != null) {
                    JSONParser jsonParser = new JSONParser();
                    FileReader authReader = new FileReader(pathToAuthFile);
                    Object obj = jsonParser.parse((Reader)authReader);
                    JSONObject authJSONObject = (JSONObject)obj;
                    if (authJSONObject != null) {
                        this.adminSystemKey = authJSONObject.get((Object)"systemKey").toString();
                        this.adminToken = authJSONObject.get((Object)"token").toString();
                        this.baseURL = authJSONObject.get((Object)"url").toString();
                        this.project = authJSONObject.get((Object)"project").toString();
                    }
                    break block6;
                }
                log.log(Level.SEVERE, "CLEARBLADE_CONFIGURATION Enviornment variable not set");
                throw new ApplicationException("CLEARBLADE_CONFIGURATION Enviornment variable not set");
            }
            catch (FileNotFoundException fe) {
                log.log(Level.SEVERE, "ClearBlade Configuration File not found");
                throw new FileNotFoundException("ClearBlade Configuration File not found");
            }
            catch (IOException fe) {
                log.log(Level.SEVERE, "Access Denied - ClearBlade Configuration File cannot be read");
                throw new IOException("Access Denied - ClearBlade Configuration File cannot be read");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage());
                throw new ApplicationException(e.getMessage());
            }
        }
    }

    public void setRegistryCredentials(String project, String registry, String location) throws ApplicationException {
        block8: {
            if (cachedResponse.containsKey(location + "-" + registry)) {
                String responseMessage = cachedResponse.get(location + "-" + registry);
                JSONParser responseParser = new JSONParser();
                Object responseObj = null;
                try {
                    responseObj = responseParser.parse(responseMessage);
                }
                catch (ParseException e) {
                    throw new ApplicationException(e);
                }
                if (responseObj != null) {
                    JSONObject responseJSONObject = (JSONObject)responseObj;
                    this.userSystemKey = responseJSONObject.get((Object)"systemKey").toString();
                    this.userToken = responseJSONObject.get((Object)"serviceAccountToken").toString();
                    this.apiBaseURL = responseJSONObject.get((Object)"url").toString();
                }
                return;
            }
            try {
                this.setAdminCredentials();
                String finalURL = this.baseURL.concat("/api/v/1/code/").concat(this.adminSystemKey).concat("/getRegistryCredentials");
                JSONObject js = new JSONObject();
                js.put((Object)"region", (Object)location);
                js.put((Object)"registry", (Object)registry);
                js.put((Object)"project", (Object)project);
                HttpRequest.BodyPublisher jsonPayload = HttpRequest.BodyPublishers.ofString(js.toString());
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(finalURL)).method("POST", jsonPayload).headers("Content-Type", "application/json", "ClearBlade-UserToken", this.adminToken, "Accept", "application/json").build();
                HttpResponse<String> response = HttpClient.newBuilder().proxy(ProxySelector.getDefault()).build().send(request, HttpResponse.BodyHandlers.ofString());
                int responseCode = response.statusCode();
                String responseMessage = response.body();
                JSONParser responseParser = new JSONParser();
                if (responseCode == 200) {
                    Object responseObj;
                    if (responseMessage != null && responseMessage.length() > 0 && (responseObj = responseParser.parse(responseMessage)) != null) {
                        JSONObject responseJSONObject = (JSONObject)responseObj;
                        this.userSystemKey = responseJSONObject.get((Object)"systemKey").toString();
                        this.userToken = responseJSONObject.get((Object)"serviceAccountToken").toString();
                        this.apiBaseURL = responseJSONObject.get((Object)"url").toString();
                        cachedResponse.put(location + "-" + registry, responseMessage);
                    }
                    break block8;
                }
                log.log(Level.INFO, () -> "Response code " + responseCode + " received with message::" + responseMessage);
                throw new ApplicationException(responseMessage);
            }
            catch (Exception ec) {
                log.log(Level.SEVERE, ec.getMessage());
                throw new ApplicationException(ec.getMessage());
            }
        }
    }
}

