/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.utils;

public enum LogLevel {
    LOG_LEVEL_UNSPECIFIED(0),
    NONE(10),
    ERROR(20),
    INFO(30),
    DEBUG(40),
    UNRECOGNIZED(-1);

    public static final int LOG_LEVEL_UNSPECIFIED_VALUE = 0;
    public static final int NONE_VALUE = 10;
    public static final int ERROR_VALUE = 20;
    public static final int INFO_VALUE = 30;
    public static final int DEBUG_VALUE = 40;
    private final int value;

    public final int getNumber() {
        if (this == UNRECOGNIZED) {
            throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
        }
        return this.value;
    }

    public static LogLevel valueOf(int value) {
        return LogLevel.forNumber(value);
    }

    public static LogLevel forNumber(int value) {
        switch (value) {
            case 0: {
                return LOG_LEVEL_UNSPECIFIED;
            }
            case 10: {
                return NONE;
            }
            case 20: {
                return ERROR;
            }
            case 30: {
                return INFO;
            }
            case 40: {
                return DEBUG;
            }
        }
        return null;
    }

    public LogLevel findValueByNumber(int number) {
        return LogLevel.forNumber(number);
    }

    private LogLevel(int value) {
        this.value = value;
    }
}

