/*
 * Decompiled with CFR 0.152.
 */
package com.clearblade.cloud.iot.v1.utils;

import com.clearblade.cloud.iot.v1.utils.AutoValue;
import com.clearblade.cloud.iot.v1.utils.AutoValue_PathTemplate_Segment;
import com.clearblade.cloud.iot.v1.utils.TemplatedResourceName;
import com.clearblade.cloud.iot.v1.utils.ValidationException;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableListIterator;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class PathTemplate {
    public static final String HOSTNAME_VAR = "$hostname";
    private static final Pattern CUSTOM_VERB_PATTERN = Pattern.compile(":([^/*}{=]+)$");
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("^(\\w+:)?//");
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/').trimResults();
    private static final Pattern COMPLEX_DELIMITER_PATTERN = Pattern.compile("[_\\-\\.~]");
    private static final Pattern MULTIPLE_COMPLEX_DELIMITER_PATTERN = Pattern.compile("\\}[_\\-\\.~]{2,}\\{");
    private static final Pattern MISSING_COMPLEX_DELIMITER_PATTERN = Pattern.compile("\\}\\{");
    private static final Pattern INVALID_COMPLEX_DELIMITER_PATTERN = Pattern.compile("\\}[^_\\-\\.~]\\{");
    private static final Pattern END_SEGMENT_COMPLEX_DELIMITER_PATTERN = Pattern.compile("\\}[_\\-\\.~]{1}");
    private final ImmutableList<Segment> segments;
    private final ImmutableMap<String, Segment> bindings;
    private final boolean urlEncoding;

    public static PathTemplate create(String template) {
        return PathTemplate.create(template, true);
    }

    public static PathTemplate createWithoutUrlEncoding(String template) {
        return PathTemplate.create(template, false);
    }

    private static PathTemplate create(String template, boolean urlEncoding) {
        return new PathTemplate((Iterable<Segment>)PathTemplate.parseTemplate(template), urlEncoding);
    }

    private PathTemplate(Iterable<Segment> segments, boolean urlEncoding) {
        this.segments = ImmutableList.copyOf(segments);
        if (this.segments.isEmpty()) {
            throw new ValidationException("template cannot be empty.", new Object[0]);
        }
        LinkedHashMap bindings = Maps.newLinkedHashMap();
        for (Segment seg : this.segments) {
            if (seg.kind() != SegmentKind.BINDING) continue;
            if (bindings.containsKey(seg.value())) {
                throw new ValidationException("Duplicate binding '%s'", seg.value());
            }
            bindings.put(seg.value(), seg);
        }
        this.bindings = ImmutableMap.copyOf((Map)bindings);
        this.urlEncoding = urlEncoding;
    }

    public Set<String> vars() {
        return this.bindings.keySet();
    }

    public PathTemplate parentTemplate() {
        Segment seg;
        int i = this.segments.size();
        if ((seg = (Segment)this.segments.get(--i)).kind() == SegmentKind.END_BINDING) {
            while (i > 0 && ((Segment)this.segments.get(--i)).kind() != SegmentKind.BINDING) {
            }
        }
        if (i == 0) {
            throw new ValidationException("template does not have a parent", new Object[0]);
        }
        return new PathTemplate((Iterable<Segment>)this.segments.subList(0, i), this.urlEncoding);
    }

    public PathTemplate withoutVars() {
        StringBuilder result = new StringBuilder();
        UnmodifiableListIterator iterator = this.segments.listIterator();
        boolean start = true;
        block3: while (iterator.hasNext()) {
            Segment seg = (Segment)iterator.next();
            switch (seg.kind()) {
                case END_BINDING: 
                case BINDING: {
                    continue block3;
                }
            }
            if (!start) {
                result.append(seg.separator());
            } else {
                start = false;
            }
            result.append(seg.value());
        }
        return PathTemplate.create(result.toString(), this.urlEncoding);
    }

    public PathTemplate subTemplate(String varName) {
        ArrayList sub = Lists.newArrayList();
        boolean inBinding = false;
        for (Segment seg : this.segments) {
            if (seg.kind() == SegmentKind.BINDING && seg.value().equals(varName)) {
                inBinding = true;
                continue;
            }
            if (!inBinding) continue;
            if (seg.kind() == SegmentKind.END_BINDING) {
                return PathTemplate.create(PathTemplate.toSyntax(sub, true), this.urlEncoding);
            }
            sub.add(seg);
        }
        throw new ValidationException(String.format("Variable '%s' is undefined in template '%s'", varName, this.toRawString()), new Object[0]);
    }

    public boolean endsWithLiteral() {
        return ((Segment)this.segments.get(this.segments.size() - 1)).kind() == SegmentKind.LITERAL;
    }

    public boolean endsWithCustomVerb() {
        return ((Segment)this.segments.get(this.segments.size() - 1)).kind() == SegmentKind.CUSTOM_VERB;
    }

    public TemplatedResourceName parse(String path) {
        return TemplatedResourceName.create(this, path);
    }

    @Nullable
    public String singleVar() {
        return this.bindings.size() == 1 ? (String)((Map.Entry)this.bindings.entrySet().iterator().next()).getKey() : null;
    }

    public void validate(String path, String exceptionMessagePrefix) {
        if (!this.matches(path)) {
            throw new ValidationException(String.format("%s: Parameter \"%s\" must be in the form \"%s\"", exceptionMessagePrefix, path, this.toString()), new Object[0]);
        }
    }

    public Map<String, String> validatedMatch(String path, String exceptionMessagePrefix) {
        Map<String, String> matchMap = this.match(path);
        if (matchMap == null) {
            throw new ValidationException(String.format("%s: Parameter \"%s\" must be in the form \"%s\"", exceptionMessagePrefix, path, this.toString()), new Object[0]);
        }
        return matchMap;
    }

    public boolean matches(String path) {
        return this.match(path) != null;
    }

    @Nullable
    public Map<String, String> match(String path) {
        return this.match(path, false);
    }

    @Nullable
    public Map<String, String> matchFromFullName(String path) {
        return this.match(path, true);
    }

    private Map<String, String> match(String path, boolean forceHostName) {
        boolean withHostName;
        Matcher matcher;
        Segment last = (Segment)this.segments.get(this.segments.size() - 1);
        if (last.kind() == SegmentKind.CUSTOM_VERB) {
            matcher = CUSTOM_VERB_PATTERN.matcher(path);
            if (!matcher.find() || !this.decodeUrl(matcher.group(1)).equals(last.value())) {
                return null;
            }
            path = path.substring(0, matcher.start(0));
        }
        if (withHostName = (matcher = HOSTNAME_PATTERN.matcher(path)).find()) {
            path = matcher.replaceFirst("");
        }
        List input = SLASH_SPLITTER.splitToList((CharSequence)path);
        int inPos = 0;
        LinkedHashMap values = Maps.newLinkedHashMap();
        if (withHostName || forceHostName) {
            if (input.isEmpty()) {
                return null;
            }
            Object hostName = (String)input.get(inPos++);
            if (withHostName) {
                hostName = matcher.group(0) + (String)hostName;
            }
            values.put(HOSTNAME_VAR, hostName);
        }
        if (withHostName) {
            inPos = this.alignInputToAlignableSegment(input, inPos, (Segment)this.segments.get(0));
        }
        if (!this.match(input, inPos, (List<Segment>)this.segments, 0, values)) {
            return null;
        }
        return ImmutableMap.copyOf((Map)values);
    }

    private int alignInputToAlignableSegment(List<String> input, int inPos, Segment segment) {
        switch (segment.kind()) {
            case BINDING: {
                inPos = this.alignInputPositionToLiteral(input, inPos, segment.value() + "s");
                return inPos + 1;
            }
            case LITERAL: {
                return this.alignInputPositionToLiteral(input, inPos, segment.value());
            }
        }
        return inPos;
    }

    private int alignInputPositionToLiteral(List<String> input, int inPos, String literalSegmentValue) {
        while (inPos < input.size()) {
            if (literalSegmentValue.equals(input.get(inPos))) {
                return inPos;
            }
            ++inPos;
        }
        return inPos;
    }

    private boolean match(List<String> input, int inPos, List<Segment> segments, int segPos, Map<String, String> values) {
        String currentVar = null;
        ArrayList<String> modifiableInput = new ArrayList<String>(input);
        block9: while (segPos < segments.size()) {
            int available;
            int complexSeparatorIndex;
            Segment seg = segments.get(segPos++);
            switch (seg.kind()) {
                default: {
                    continue block9;
                }
                case END_BINDING: {
                    currentVar = null;
                    continue block9;
                }
                case BINDING: {
                    currentVar = seg.value();
                    continue block9;
                }
                case LITERAL: 
                case WILDCARD: {
                    if (inPos >= modifiableInput.size()) {
                        return false;
                    }
                    String next = this.decodeUrl((String)modifiableInput.get(inPos++));
                    if (seg.kind() == SegmentKind.LITERAL && !seg.value().equals(next)) {
                        return false;
                    }
                    if (seg.kind() == SegmentKind.WILDCARD && !seg.complexSeparator().isEmpty()) {
                        complexSeparatorIndex = next.indexOf(seg.complexSeparator());
                        if (complexSeparatorIndex < 0) {
                            return false;
                        }
                        modifiableInput.add(inPos, next.substring(complexSeparatorIndex + 1));
                        next = next.substring(0, complexSeparatorIndex);
                        modifiableInput.set(inPos - 1, next);
                    }
                    if (currentVar == null) continue block9;
                    values.put(currentVar, PathTemplate.concatCaptures(values.get(currentVar), next));
                    continue block9;
                }
                case PATH_WILDCARD: 
            }
            complexSeparatorIndex = 0;
            for (available = segPos; available < segments.size(); ++available) {
                switch (segments.get(available).kind()) {
                    default: {
                        ++complexSeparatorIndex;
                    }
                    case END_BINDING: 
                    case BINDING: 
                    case CUSTOM_VERB: 
                }
            }
            available = modifiableInput.size() - inPos - complexSeparatorIndex;
            if (available == 0 && !values.containsKey(currentVar)) {
                values.put(currentVar, "");
            }
            while (available-- > 0) {
                values.put(currentVar, PathTemplate.concatCaptures(values.get(currentVar), this.decodeUrl((String)modifiableInput.get(inPos++))));
            }
        }
        return inPos == modifiableInput.size();
    }

    private static String concatCaptures(@Nullable String cur, String next) {
        return cur == null ? next : cur + "/" + next;
    }

    public String instantiate(Map<String, String> values) {
        return this.instantiate(values, false);
    }

    public String instantiate(String ... keysAndValues) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            builder.put((Object)keysAndValues[i], (Object)keysAndValues[i + 1]);
        }
        return this.instantiate((Map<String, String>)builder.build());
    }

    public String instantiatePartial(Map<String, String> values) {
        return this.instantiate(values, true);
    }

    private String instantiate(Map<String, String> values, boolean allowPartial) {
        StringBuilder result = new StringBuilder();
        if (values.containsKey(HOSTNAME_VAR)) {
            result.append(values.get(HOSTNAME_VAR));
            result.append('/');
        }
        boolean continueLast = true;
        boolean skip = false;
        UnmodifiableListIterator iterator = this.segments.listIterator();
        String prevSeparator = "";
        block4: while (iterator.hasNext()) {
            String var;
            Segment seg = (Segment)iterator.next();
            if (!skip && !continueLast) {
                var = !prevSeparator.isEmpty() && iterator.hasNext() ? prevSeparator : seg.separator();
                result.append(var);
                prevSeparator = seg.complexSeparator().isEmpty() ? seg.separator() : seg.complexSeparator();
            }
            continueLast = false;
            switch (seg.kind()) {
                case END_BINDING: {
                    if (!skip) {
                        result.append('}');
                    }
                    skip = false;
                    continue block4;
                }
                case BINDING: {
                    var = seg.value();
                    String value = values.get(seg.value());
                    if (value == null) {
                        if (!allowPartial) {
                            throw new ValidationException(String.format("Unbound variable '%s'. Bindings: %s", var, values), new Object[0]);
                        }
                        if (var.startsWith("$")) {
                            result.append(((Segment)iterator.next()).value());
                            iterator.next();
                            continue block4;
                        }
                        result.append('{');
                        result.append(seg.value());
                        result.append('=');
                        continueLast = true;
                        continue block4;
                    }
                    Segment next = (Segment)iterator.next();
                    Segment nextNext = (Segment)iterator.next();
                    boolean pathEscape = next.kind() == SegmentKind.PATH_WILDCARD || nextNext.kind() != SegmentKind.END_BINDING;
                    PathTemplate.restore(iterator, iterator.nextIndex() - 2);
                    if (!pathEscape) {
                        result.append(this.encodeUrl(value));
                    } else {
                        boolean first = true;
                        for (String subSeg : SLASH_SPLITTER.split((CharSequence)value)) {
                            if (!first) {
                                result.append('/');
                            }
                            first = false;
                            result.append(this.encodeUrl(subSeg));
                        }
                    }
                    skip = true;
                    continue block4;
                }
            }
            if (skip) continue;
            result.append(seg.value());
        }
        return result.toString();
    }

    public String encode(String ... values) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        int i = 0;
        String[] var4 = values;
        int var5 = values.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String value = var4[var6];
            builder.put((Object)("$" + i++), (Object)value);
        }
        return this.instantiate((Map<String, String>)builder.build());
    }

    public List<String> decode(String path) {
        Map<String, String> match = this.match(path);
        if (match == null) {
            throw new IllegalArgumentException(String.format("template '%s' does not match '%s'", this, path));
        }
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, String> entry : match.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("$")) {
                throw new IllegalArgumentException("template must not contain named bindings");
            }
            int i = Integer.parseInt(key.substring(1));
            while (result.size() <= i) {
                result.add("");
            }
            result.set(i, entry.getValue());
        }
        return ImmutableList.copyOf((Collection)result);
    }

    private static ImmutableList<Segment> parseTemplate(String template) {
        if (template.startsWith("/")) {
            template = template.substring(1);
        }
        Matcher matcher = CUSTOM_VERB_PATTERN.matcher(template);
        String customVerb = null;
        if (matcher.find()) {
            customVerb = matcher.group(1);
            template = template.substring(0, matcher.start(0));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        String varName = null;
        int freeWildcardCounter = 0;
        int pathWildCardBound = 0;
        for (String seg : Splitter.on((char)'/').trimResults().split((CharSequence)template)) {
            if (!seg.equals("_deleted-topic_")) {
                boolean isCollectionWildcard;
                boolean isLastSegment = template.indexOf(seg) + seg.length() == template.length();
                boolean bl = isCollectionWildcard = !isLastSegment && (seg.equals("-") || seg.equals("-}"));
                if (!isCollectionWildcard && PathTemplate.isSegmentBeginOrEndInvalid(seg)) {
                    throw new ValidationException("parse error: invalid begin or end character in '%s'", seg);
                }
                if (MULTIPLE_COMPLEX_DELIMITER_PATTERN.matcher(seg).find() || MISSING_COMPLEX_DELIMITER_PATTERN.matcher(seg).find()) {
                    throw new ValidationException("parse error: missing or 2+ consecutive delimiter characters in '%s'", seg);
                }
                boolean bindingStarts = seg.startsWith("{");
                boolean implicitWildcard = false;
                boolean complexDelimiterFound = false;
                if (bindingStarts) {
                    if (varName != null) {
                        throw new ValidationException("parse error: nested binding in '%s'", template);
                    }
                    if (INVALID_COMPLEX_DELIMITER_PATTERN.matcher(seg = seg.substring(1)).find()) {
                        throw new ValidationException("parse error: invalid complex resource ID delimiter character in '%s'", seg);
                    }
                    Matcher complexPatternDelimiterMatcher = END_SEGMENT_COMPLEX_DELIMITER_PATTERN.matcher(seg);
                    boolean bl2 = complexDelimiterFound = !isCollectionWildcard && complexPatternDelimiterMatcher.find();
                    if (complexDelimiterFound) {
                        builder.addAll(PathTemplate.parseComplexResourceId(seg));
                    } else {
                        int i = seg.indexOf(61);
                        if (i <= 0) {
                            if (!seg.endsWith("}")) {
                                throw new ValidationException("parse error: invalid binding syntax in '%s'", template);
                            }
                            implicitWildcard = true;
                            varName = seg.substring(0, seg.length() - 1).trim();
                            seg = seg.substring(seg.length() - 1).trim();
                        } else if (seg.indexOf(45) <= 0 && isCollectionWildcard) {
                            implicitWildcard = true;
                        } else {
                            varName = seg.substring(0, i).trim();
                            seg = seg.substring(i + 1).trim();
                        }
                        builder.add((Object)Segment.create(SegmentKind.BINDING, varName));
                    }
                }
                if (complexDelimiterFound) continue;
                boolean bindingEnds = seg.endsWith("}");
                if (bindingEnds) {
                    seg = seg.substring(0, seg.length() - 1).trim();
                }
                switch (seg) {
                    case "**": 
                    case "*": {
                        Segment wildcard;
                        if ("**".equals(seg)) {
                            ++pathWildCardBound;
                        }
                        Segment segment = wildcard = seg.length() == 2 ? Segment.PATH_WILDCARD : Segment.WILDCARD;
                        if (varName == null) {
                            builder.add((Object)Segment.create(SegmentKind.BINDING, "$" + freeWildcardCounter));
                            ++freeWildcardCounter;
                            builder.add((Object)wildcard);
                            builder.add((Object)Segment.END_BINDING);
                            break;
                        }
                        builder.add((Object)wildcard);
                        break;
                    }
                    case "": {
                        if (bindingEnds) break;
                        throw new ValidationException("parse error: empty segment not allowed in '%s'", template);
                    }
                    case "-": {
                        builder.add((Object)Segment.WILDCARD);
                        implicitWildcard = false;
                        break;
                    }
                    default: {
                        builder.add((Object)Segment.create(SegmentKind.LITERAL, seg));
                    }
                }
                if (bindingEnds && !complexDelimiterFound) {
                    varName = null;
                    if (implicitWildcard) {
                        builder.add((Object)Segment.WILDCARD);
                    }
                    builder.add((Object)Segment.END_BINDING);
                }
                if (pathWildCardBound <= 1) continue;
                throw new ValidationException("parse error: pattern must not contain more than one path wildcard ('**') in '%s'", template);
            }
            builder.add((Object)Segment.create(SegmentKind.LITERAL, seg));
        }
        if (customVerb != null) {
            builder.add((Object)Segment.create(SegmentKind.CUSTOM_VERB, customVerb));
        }
        return builder.build();
    }

    private static boolean isSegmentBeginOrEndInvalid(String seg) {
        if (seg.length() == 1 && COMPLEX_DELIMITER_PATTERN.matcher(seg).find()) {
            return true;
        }
        return COMPLEX_DELIMITER_PATTERN.matcher(seg.substring(0, 1)).find() && seg.charAt(1) == '{' || COMPLEX_DELIMITER_PATTERN.matcher(seg.substring(seg.length() - 1)).find() && seg.charAt(seg.length() - 2) == '}';
    }

    private static List<Segment> parseComplexResourceId(String seg) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        ArrayList<String> separatorIndices = new ArrayList<String>();
        Matcher complexPatternDelimiterMatcher = END_SEGMENT_COMPLEX_DELIMITER_PATTERN.matcher(seg);
        boolean delimiterFound = complexPatternDelimiterMatcher.find();
        while (delimiterFound) {
            String currDelimiter;
            int delimiterIndex = complexPatternDelimiterMatcher.start();
            if (seg.substring(delimiterIndex).startsWith("}")) {
                ++delimiterIndex;
            }
            if (!COMPLEX_DELIMITER_PATTERN.matcher(currDelimiter = seg.substring(delimiterIndex, delimiterIndex + 1)).find()) {
                throw new ValidationException("parse error: invalid complex ID delimiter '%s' in '%s'", currDelimiter, seg);
            }
            separatorIndices.add(currDelimiter);
            delimiterFound = complexPatternDelimiterMatcher.find(delimiterIndex + 1);
        }
        separatorIndices.add("");
        String subVarName = null;
        Iterable complexSubsegments = Splitter.onPattern((String)"\\}[_\\-\\.~]").trimResults().split((CharSequence)seg);
        boolean complexSegImplicitWildcard = false;
        int currIteratorIndex = 0;
        for (String complexSeg : complexSubsegments) {
            boolean subsegmentBindingStarts = complexSeg.startsWith("{");
            if (subsegmentBindingStarts) {
                if (subVarName != null) {
                    throw new ValidationException("parse error: nested binding in '%s'", complexSeg);
                }
                complexSeg = complexSeg.substring(1);
            }
            subVarName = complexSeg.trim();
            boolean subBindingEnds = complexSeg.endsWith("}");
            int i = complexSeg.indexOf(61);
            if (i <= 0) {
                if (subBindingEnds) {
                    complexSegImplicitWildcard = true;
                    subVarName = complexSeg.substring(0, complexSeg.length() - 1).trim();
                    complexSeg = complexSeg.substring(complexSeg.length() - 1).trim();
                }
            } else {
                subVarName = complexSeg.substring(0, i).trim();
                if ((complexSeg = complexSeg.substring(i + 1).trim()).equals("**")) {
                    throw new ValidationException("parse error: wildcard path not allowed in complex ID resource '%s'", subVarName);
                }
            }
            String complexDelimiter = currIteratorIndex < separatorIndices.size() ? (String)separatorIndices.get(currIteratorIndex) : "";
            segments.add(Segment.create(SegmentKind.BINDING, subVarName, complexDelimiter));
            segments.add(Segment.wildcardCreate(complexDelimiter));
            segments.add(Segment.END_BINDING);
            subVarName = null;
            ++currIteratorIndex;
        }
        return segments;
    }

    private String encodeUrl(String text) {
        if (this.urlEncoding) {
            try {
                return URLEncoder.encode(text, "UTF-8");
            }
            catch (UnsupportedEncodingException var3) {
                throw new ValidationException("UTF-8 encoding is not supported on this platform", new Object[0]);
            }
        }
        String INVALID_CHAR = "/";
        if (text.contains("/")) {
            throw new ValidationException("Invalid character \"/\" in path section \"" + text + "\".", new Object[0]);
        }
        return text;
    }

    private String decodeUrl(String url) {
        if (this.urlEncoding) {
            try {
                return URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException var3) {
                throw new ValidationException("UTF-8 encoding is not supported on this platform", new Object[0]);
            }
        }
        return url;
    }

    private static boolean peek(ListIterator<Segment> segments, SegmentKind ... kinds) {
        int start = segments.nextIndex();
        boolean success = false;
        SegmentKind[] var4 = kinds;
        int var5 = kinds.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            SegmentKind kind = var4[var6];
            if (segments.hasNext() && segments.next().kind() == kind) continue;
            success = false;
            break;
        }
        if (success) {
            return true;
        }
        PathTemplate.restore(segments, start);
        return false;
    }

    private static void restore(ListIterator<?> segments, int index) {
        while (segments.nextIndex() > index) {
            segments.previous();
        }
    }

    public String toString() {
        return PathTemplate.toSyntax(this.segments, true);
    }

    public String toRawString() {
        return PathTemplate.toSyntax(this.segments, false);
    }

    private static String toSyntax(List<Segment> segments, boolean pretty) {
        StringBuilder result = new StringBuilder();
        boolean continueLast = true;
        ListIterator<Segment> iterator = segments.listIterator();
        block4: while (iterator.hasNext()) {
            Segment seg = iterator.next();
            if (!continueLast) {
                result.append(seg.separator());
            }
            continueLast = false;
            switch (seg.kind()) {
                case END_BINDING: {
                    result.append('}');
                    continue block4;
                }
                case BINDING: {
                    if (pretty && seg.value().startsWith("$")) {
                        seg = iterator.next();
                        result.append(seg.value());
                        iterator.next();
                        continue block4;
                    }
                    result.append('{');
                    result.append(seg.value());
                    if (pretty && PathTemplate.peek(iterator, SegmentKind.WILDCARD, SegmentKind.END_BINDING)) {
                        result.append('}');
                        continue block4;
                    }
                    result.append('=');
                    continueLast = true;
                    continue block4;
                }
            }
            result.append(seg.value());
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathTemplate)) {
            return false;
        }
        PathTemplate other = (PathTemplate)obj;
        return Objects.equals(this.segments, other.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    static enum SegmentKind {
        LITERAL,
        CUSTOM_VERB,
        WILDCARD,
        PATH_WILDCARD,
        BINDING,
        END_BINDING;

    }

    @AutoValue
    static abstract class Segment {
        private static final Segment WILDCARD = Segment.create(SegmentKind.WILDCARD, "*");
        private static final Segment PATH_WILDCARD = Segment.create(SegmentKind.PATH_WILDCARD, "**");
        private static final Segment END_BINDING = Segment.create(SegmentKind.END_BINDING, "");

        Segment() {
        }

        private static Segment create(SegmentKind kind, String value) {
            return new AutoValue_PathTemplate_Segment(kind, value, "");
        }

        private static Segment create(SegmentKind kind, String value, String complexSeparator) {
            return new AutoValue_PathTemplate_Segment(kind, value, complexSeparator);
        }

        private static Segment wildcardCreate(String complexSeparator) {
            return new AutoValue_PathTemplate_Segment(SegmentKind.WILDCARD, "*", !complexSeparator.isEmpty() && COMPLEX_DELIMITER_PATTERN.matcher(complexSeparator).find() ? complexSeparator : "");
        }

        abstract SegmentKind kind();

        abstract String value();

        abstract String complexSeparator();

        boolean isAnyWildcard() {
            return this.kind() == SegmentKind.WILDCARD || this.kind() == SegmentKind.PATH_WILDCARD;
        }

        String separator() {
            switch (this.kind()) {
                case CUSTOM_VERB: {
                    return ":";
                }
                case END_BINDING: {
                    return "";
                }
            }
            return "/";
        }
    }
}

