/*
 * Decompiled with CFR 0.152.
 */
package test.com.clearblade.cloud.iot.v1.test;

import com.clearblade.cloud.iot.v1.DeviceManagerClient;
import com.clearblade.cloud.iot.v1.binddevicetogateway.BindDeviceToGatewayRequest;
import com.clearblade.cloud.iot.v1.binddevicetogateway.BindDeviceToGatewayResponse;
import com.clearblade.cloud.iot.v1.createdevice.CreateDeviceRequest;
import com.clearblade.cloud.iot.v1.createdeviceregistry.CreateDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.deletedevice.DeleteDeviceRequest;
import com.clearblade.cloud.iot.v1.deletedeviceregistry.DeleteDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.devicetypes.Device;
import com.clearblade.cloud.iot.v1.devicetypes.DeviceConfig;
import com.clearblade.cloud.iot.v1.devicetypes.DeviceCredential;
import com.clearblade.cloud.iot.v1.devicetypes.DeviceName;
import com.clearblade.cloud.iot.v1.devicetypes.FieldMask;
import com.clearblade.cloud.iot.v1.devicetypes.GatewayConfig;
import com.clearblade.cloud.iot.v1.devicetypes.GatewayType;
import com.clearblade.cloud.iot.v1.devicetypes.Status;
import com.clearblade.cloud.iot.v1.getdevice.GetDeviceRequest;
import com.clearblade.cloud.iot.v1.getdeviceregistry.GetDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.registrytypes.DeviceRegistry;
import com.clearblade.cloud.iot.v1.registrytypes.LocationName;
import com.clearblade.cloud.iot.v1.registrytypes.RegistryName;
import com.clearblade.cloud.iot.v1.sendcommandtodevice.SendCommandToDeviceRequest;
import com.clearblade.cloud.iot.v1.sendcommandtodevice.SendCommandToDeviceResponse;
import com.clearblade.cloud.iot.v1.unbinddevicefromgateway.UnbindDeviceFromGatewayRequest;
import com.clearblade.cloud.iot.v1.unbinddevicefromgateway.UnbindDeviceFromGatewayResponse;
import com.clearblade.cloud.iot.v1.updatedevice.UpdateDeviceRequest;
import com.clearblade.cloud.iot.v1.updatedeviceregistry.UpdateDeviceRegistryRequest;
import com.clearblade.cloud.iot.v1.utils.ByteString;
import com.clearblade.cloud.iot.v1.utils.LogLevel;
import java.util.ArrayList;
import java.util.HashMap;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import test.com.clearblade.cloud.iot.v1.test.ExpectedResponseTest;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class DeviceManagerClientTest {
    private static DeviceManagerClient client;
    private static ExpectedResponseTest testResponse;
    private String project = "xxx";
    private String location = "xxx";
    private String registryId = "xxx";
    private String failedRegistryId = "xxx";
    private String deviceId = "xxx";
    private String gatewayId = "xxx";
    private String numDeviceId = "xxx";
    private String numGatewayId = "xxx";

    @BeforeAll
    public static void setUp() {
        client = new DeviceManagerClient();
        testResponse = new ExpectedResponseTest();
    }

    @Test
    @Order(value=1)
    public void testCreateRegistrySuccess() {
        DeviceRegistry expectedResponse = testResponse.getResponseTest2(this.registryId);
        CreateDeviceRegistryRequest request = CreateDeviceRegistryRequest.Builder.newBuilder().setParent(LocationName.of(this.project, this.location).toString()).setDeviceRegistry(DeviceRegistry.newBuilder().setId(this.registryId).setLogLevel(LogLevel.DEBUG).build()).build();
        DeviceRegistry actualResponse = client.createDeviceRegistry(request);
        testResponse.assertEquals(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=2)
    public void testGetRegistrySuccess() {
        DeviceRegistry expectedResponse = testResponse.getResponseTest3(this.registryId);
        GetDeviceRegistryRequest request = GetDeviceRegistryRequest.Builder.newBuilder().setName(RegistryName.of(this.project, this.location, this.registryId).getRegistryFullName()).build();
        DeviceRegistry actualResponse = client.getDeviceRegistry(request);
        testResponse.assertEquals(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=3)
    public void testGetRegistryFail() {
        GetDeviceRegistryRequest request = GetDeviceRegistryRequest.Builder.newBuilder().setName(RegistryName.of(this.project, this.location, this.failedRegistryId).getRegistryFullName()).build();
        DeviceRegistry actualResponse = null;
        try {
            actualResponse = client.getDeviceRegistry(request);
        }
        catch (Exception e) {
            testResponse.assertException(e);
            testResponse.assertContains(e.getMessage(), "No systems found matching that combination of project, region and registry:");
        }
        testResponse.assertEqualsNull(actualResponse);
    }

    @Test
    @Order(value=4)
    public void testUpdateDeviceRegistrySuccess() {
        RegistryName name = RegistryName.of(this.project, this.location, this.registryId);
        DeviceRegistry expectedResponse = testResponse.getResponseTest5(this.registryId);
        UpdateDeviceRegistryRequest request = UpdateDeviceRegistryRequest.Builder.newBuilder().setDeviceRegistry(DeviceRegistry.newBuilder().setId(this.registryId).setName(name.getRegistryFullName()).setLogLevel(LogLevel.ERROR).build()).setName(name.getRegistryFullName()).setUpdateMask("logLevel").build();
        DeviceRegistry actualResponse = client.updateDeviceRegistry(request);
        testResponse.assertEquals(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=5)
    public void testCreateDeviceSuccess() {
        RegistryName parent = RegistryName.of(this.project, this.location, this.registryId);
        Device expectedResponse = testResponse.getResponseTest7(this.deviceId, this.numDeviceId);
        GatewayConfig gatewayCfg = GatewayConfig.newBuilder().setGatewayType(GatewayType.NON_GATEWAY).build();
        Device device = Device.newBuilder().setId(this.deviceId).setName(this.deviceId).setNumId(this.numDeviceId).setBlocked(false).setGatewayConfig(gatewayCfg).setLogLevel(LogLevel.DEBUG).setCredentials(new ArrayList<DeviceCredential>()).setLastErrorStatus(new Status()).setConfig(new DeviceConfig()).setMetadata(new HashMap<String, String>()).build();
        CreateDeviceRequest request = CreateDeviceRequest.Builder.newBuilder().setParent(parent.toString()).setDevice(device).build();
        Device actualResponse = client.createDevice(request);
        testResponse.assertEqual(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=6)
    public void testCreateDeviceAsAGatewaySuccess() {
        RegistryName parent = RegistryName.of(this.project, this.location, this.registryId);
        Device expectedResponse = testResponse.getResponseTest8(this.gatewayId, this.numGatewayId);
        GatewayConfig gatewayCfg = GatewayConfig.newBuilder().setGatewayType(GatewayType.GATEWAY).build();
        Device device = Device.newBuilder().setId(this.gatewayId).setName(this.gatewayId).setNumId(this.numGatewayId).setBlocked(false).setGatewayConfig(gatewayCfg).setLogLevel(LogLevel.DEBUG).setCredentials(new ArrayList<DeviceCredential>()).setLastErrorStatus(new Status()).setConfig(new DeviceConfig()).setMetadata(new HashMap<String, String>()).build();
        CreateDeviceRequest request = CreateDeviceRequest.Builder.newBuilder().setParent(parent.toString()).setDevice(device).build();
        Device actualResponse = client.createDevice(request);
        testResponse.assertEqual(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=7)
    public void testGetDeviceFail() {
        DeviceName name = DeviceName.of(this.project, this.location, this.registryId, "test_device02");
        Device expectedResponse = testResponse.getResponseTest9(this.deviceId, this.numDeviceId);
        GetDeviceRequest request = GetDeviceRequest.Builder.newBuilder().setName(name).setFieldMask(FieldMask.newBuilder().build()).build();
        Device actualResponse = null;
        try {
            actualResponse = client.getDevice(request);
        }
        catch (Exception e) {
            testResponse.assertException(e);
            testResponse.assertContains(e.getMessage(), "doesn't exist");
        }
        testResponse.assertEqualsNull(actualResponse);
    }

    @Test
    @Order(value=8)
    public void testGetDeviceSuccess() {
        DeviceName name = DeviceName.of(this.project, this.location, this.registryId, this.deviceId);
        Device expectedResponse = testResponse.getResponseTest10(this.deviceId, this.numDeviceId);
        GetDeviceRequest request = GetDeviceRequest.Builder.newBuilder().setName(name).setFieldMask(FieldMask.newBuilder().build()).build();
        Device actualResponse = client.getDevice(request);
        testResponse.assertEqual(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=9)
    public void testGetDeviceAsAGatewaySuccess() {
        DeviceName name = DeviceName.of(this.project, this.location, this.registryId, this.gatewayId);
        Device expectedResponse = testResponse.getResponseTest11(this.gatewayId, this.numGatewayId);
        GetDeviceRequest request = GetDeviceRequest.Builder.newBuilder().setName(name).setFieldMask(FieldMask.newBuilder().build()).build();
        Device actualResponse = client.getDevice(request);
        testResponse.assertEqual(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=10)
    public void testUpdateDevice() {
        Device expectedResponse = testResponse.getResponseTest12(this.deviceId);
        Device device = Device.patch(this.deviceId, this.deviceId, LogLevel.ERROR, true);
        DeviceName deviceName = DeviceName.of(this.project, this.location, this.registryId, this.deviceId);
        String updateMask = "logLevel";
        UpdateDeviceRequest request = UpdateDeviceRequest.Builder.newBuilder().setName(deviceName.toString()).setDevice(device).setUpdateMask(updateMask).build();
        Device actualResponse = client.updateDevice(request);
        testResponse.assertEqual(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=11)
    public void testBindDeviceToGateway() {
        BindDeviceToGatewayResponse expectedResponse = testResponse.getResponseTest13();
        BindDeviceToGatewayRequest request = BindDeviceToGatewayRequest.Builder.newBuilder().setParent(RegistryName.of(this.project, this.location, this.registryId).toString()).setGateway(this.gatewayId).setDevice(this.deviceId).build();
        BindDeviceToGatewayResponse actualResponse = client.bindDeviceToGateway(request);
        testResponse.assertEqualResponse(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=12)
    public void testUnbindDeviceFromGateway() {
        UnbindDeviceFromGatewayResponse expectedResponse = testResponse.getResponseTest14();
        UnbindDeviceFromGatewayRequest request = UnbindDeviceFromGatewayRequest.Builder.newBuilder().setParent(RegistryName.of(this.project, this.location, this.registryId).toString()).setGateway(this.gatewayId).setDevice(this.deviceId).build();
        UnbindDeviceFromGatewayResponse actualResponse = client.unbindDeviceFromGateway(request);
        testResponse.assertEqualsResponse(expectedResponse, actualResponse);
    }

    @Test
    @Order(value=13)
    public void testSendCommandToDevice() {
        String byteData = "c2VuZEZ1bm55TWVzc2FnZVRvRGV2aWNl";
        SendCommandToDeviceRequest request = SendCommandToDeviceRequest.Builder.newBuilder().setName(DeviceName.of(this.project, this.location, this.registryId, this.deviceId).toString()).setBinaryData(new ByteString(byteData)).build();
        SendCommandToDeviceResponse actualResponse = null;
        try {
            actualResponse = client.sendCommandToDevice(request);
        }
        catch (Exception e) {
            testResponse.assertException(e);
            testResponse.assertContains(e.getMessage(), " is not connected.");
        }
        testResponse.assertEqualsNull(actualResponse);
    }

    @Test
    @Order(value=14)
    public void testDeleteDevice() {
        DeviceName deviceName = DeviceName.of(this.project, this.location, this.registryId, this.deviceId);
        DeleteDeviceRequest request = DeleteDeviceRequest.Builder.newBuilder().setName(deviceName).build();
        client.deleteDevice(request);
    }

    @Test
    @Order(value=15)
    public void testDeleteDeviceAsAGateway() {
        DeviceName deviceName = DeviceName.of(this.project, this.location, this.registryId, this.gatewayId);
        DeleteDeviceRequest request = DeleteDeviceRequest.Builder.newBuilder().setName(deviceName).build();
        client.deleteDevice(request);
    }

    @Test
    @Order(value=16)
    public void testDeleteDeviceRegistry() {
        DeleteDeviceRegistryRequest request = DeleteDeviceRegistryRequest.Builder.newBuilder().setName(RegistryName.of(this.project, this.location, this.registryId).getRegistryFullName()).build();
        client.deleteDeviceRegistry(request);
    }
}

