/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.maven.plugin;

import com.github.cleydyr.dart.command.SassCommand;
import com.github.cleydyr.dart.command.builder.SassCommandBuilder;
import com.github.cleydyr.dart.command.enums.SourceMapURLs;
import com.github.cleydyr.dart.command.enums.Style;
import com.github.cleydyr.dart.command.exception.SassCommandException;
import com.github.cleydyr.dart.command.factory.SassCommandBuilderFactory;
import com.github.cleydyr.dart.system.io.DartSassExecutableExtractor;
import com.github.cleydyr.dart.system.io.factory.DartSassExecutableExtractorFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="compile-sass", defaultPhase=LifecyclePhase.PROCESS_RESOURCES)
public class CompileSassMojo
extends AbstractMojo {
    @Parameter(defaultValue="src/main/sass")
    private File inputFolder;
    @Parameter(property="project.build.directory")
    private File outputFolder;
    @Parameter
    private List<File> loadPaths;
    @Parameter(defaultValue="EXPANDED")
    private Style style;
    @Parameter(defaultValue="false")
    private boolean noCharset;
    @Parameter(defaultValue="true")
    private boolean errorCSS;
    @Parameter(defaultValue="false")
    private boolean update;
    @Parameter(defaultValue="false")
    private boolean noSourceMap;
    @Parameter(defaultValue="RELATIVE")
    private SourceMapURLs sourceMapURLs;
    @Parameter(defaultValue="false")
    private boolean embedSources;
    @Parameter(defaultValue="false")
    private boolean embedSourceMap;
    @Parameter(defaultValue="false")
    private boolean stopOnError;
    @Parameter(defaultValue="true")
    private boolean color;
    @Parameter(defaultValue="false")
    private boolean noUnicode;
    @Parameter(defaultValue="true")
    private boolean quiet;
    @Parameter(defaultValue="false")
    private boolean quietDeps;
    @Parameter(defaultValue="false")
    private boolean trace;
    private long fileCount;

    public void execute() throws MojoExecutionException {
        this.extractExecutable();
        this.unsetIncompatibleOptions();
        SassCommand sassCommand = this.buildSassCommand();
        try {
            Instant start = Instant.now();
            String output = sassCommand.execute();
            Instant finish = Instant.now();
            long elapsedTime = Duration.between(start, finish).toMillis();
            this.getLog().info((CharSequence)("Compiled " + this.fileCount + " files in " + elapsedTime + " ms"));
            if (!output.isEmpty()) {
                this.getLog().info((CharSequence)"sass command output:");
                this.getLog().info((CharSequence)output);
            }
        }
        catch (SassCommandException sassCommandException) {
            throw new MojoExecutionException("Can't execute SASS command", (Exception)sassCommandException);
        }
    }

    public void unsetIncompatibleOptions() {
        if (this.noSourceMap) {
            this.sourceMapURLs = null;
            this.embedSourceMap = false;
            this.embedSources = false;
        }
    }

    public void extractExecutable() throws MojoExecutionException {
        DartSassExecutableExtractor dartSassExecutableExtractor = DartSassExecutableExtractorFactory.getDartSassExecutableExtractor();
        try {
            dartSassExecutableExtractor.extract();
        }
        catch (IOException ioException) {
            throw new MojoExecutionException("Unable to extract sass executable", (Exception)ioException);
        }
    }

    private SassCommand buildSassCommand() throws MojoExecutionException {
        SassCommandBuilder sassCommandBuilder = SassCommandBuilderFactory.getCommanderBuilder();
        if (this.loadPaths != null) {
            for (File loadPath : this.loadPaths) {
                sassCommandBuilder.withLoadPath(loadPath.toPath());
            }
        }
        sassCommandBuilder.withStyle(this.style);
        sassCommandBuilder.withNoCharset(this.noCharset);
        sassCommandBuilder.withErrorCSS(this.errorCSS);
        sassCommandBuilder.withUpdate(this.update);
        sassCommandBuilder.withNoSourceMap(this.noSourceMap);
        sassCommandBuilder.withSourceMapURLs(this.sourceMapURLs);
        sassCommandBuilder.withEmbedSources(this.embedSources);
        sassCommandBuilder.withEmbedSourceMap(this.embedSourceMap);
        sassCommandBuilder.withStopOnError(this.stopOnError);
        sassCommandBuilder.withColor(this.color);
        sassCommandBuilder.withNoUnicode(this.noUnicode);
        sassCommandBuilder.withQuiet(this.quiet);
        sassCommandBuilder.withQuietDeps(this.quietDeps);
        sassCommandBuilder.withTrace(this.trace);
        Path inputFolderPath = this.inputFolder.toPath();
        try {
            this.fileCount = Files.list(inputFolderPath).count();
            sassCommandBuilder.withPaths(inputFolderPath, this.outputFolder.toPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't list folder " + inputFolderPath, (Exception)e);
        }
        return sassCommandBuilder.build();
    }

    public File getInputFolder() {
        return this.inputFolder;
    }

    public void setInputFolder(File inputFolder) {
        this.inputFolder = inputFolder;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public List<File> getLoadPaths() {
        return this.loadPaths;
    }

    public void setLoadPaths(List<File> loadPaths) {
        this.loadPaths = loadPaths;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean isNoCharset() {
        return this.noCharset;
    }

    public void setNoCharset(boolean noCharset) {
        this.noCharset = noCharset;
    }

    public boolean isErrorCSS() {
        return this.errorCSS;
    }

    public void setErrorCSS(boolean errorCSS) {
        this.errorCSS = errorCSS;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isNoSourceMap() {
        return this.noSourceMap;
    }

    public void setNoSourceMap(boolean noSourceMap) {
        this.noSourceMap = noSourceMap;
    }

    public SourceMapURLs getSourceMapURLs() {
        return this.sourceMapURLs;
    }

    public void setSourceMapURLs(SourceMapURLs sourceMapURLs) {
        this.sourceMapURLs = sourceMapURLs;
    }

    public boolean isEmbedSources() {
        return this.embedSources;
    }

    public void setEmbedSources(boolean embedSources) {
        this.embedSources = embedSources;
    }

    public boolean isEmbedSourceMap() {
        return this.embedSourceMap;
    }

    public void setEmbedSourceMap(boolean embedSourceMap) {
        this.embedSourceMap = embedSourceMap;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public boolean isColor() {
        return this.color;
    }

    public void setColor(boolean color) {
        this.color = color;
    }

    public boolean isNoUnicode() {
        return this.noUnicode;
    }

    public void setNoUnicode(boolean noUnicode) {
        this.noUnicode = noUnicode;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuietDeps() {
        return this.quietDeps;
    }

    public void setQuietDeps(boolean quietDeps) {
        this.quietDeps = quietDeps;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }
}

