/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.command.files;

import com.github.cleydyr.dart.command.files.FileCounter;
import com.github.cleydyr.dart.command.files.FileCounterException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class DefaultFileCounter
implements FileCounter {
    private static String[] ALLOWED_EXTENSIONS = new String[]{".css", ".sass", ".scss"};

    @Override
    public long getProcessableFileCount(Path inputFolderPath) throws FileCounterException {
        long l;
        block8: {
            Stream<Path> walk = Files.walk(inputFolderPath, new FileVisitOption[0]);
            try {
                l = ((Stream)walk.parallel()).filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(p -> p.toString()).filter(this::hasAllowedExtension).count();
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileCounterException("Can't list folder " + inputFolderPath, e);
                }
            }
            walk.close();
        }
        return l;
    }

    @Override
    public boolean hasAllowedExtension(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can't be null");
        }
        return Arrays.stream(ALLOWED_EXTENSIONS).anyMatch(fileName::endsWith);
    }
}

