/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.system.io;

import com.github.cleydyr.dart.command.exception.SassCommandException;
import com.github.cleydyr.dart.system.OSDetector;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public interface DartSassExecutableExtractor {
    default public Path createExecutableFolder() throws IOException {
        Path srcDir;
        Path executableFolder = Paths.get(System.getProperty("java.io.tmpdir"), "dart-sass-maven-plugin");
        if (!Files.isDirectory(executableFolder, new LinkOption[0])) {
            Files.createDirectory(executableFolder, new FileAttribute[0]);
        }
        if (!Files.isDirectory(srcDir = executableFolder.resolve("src"), new LinkOption[0])) {
            Files.createDirectory(srcDir, new FileAttribute[0]);
        }
        return executableFolder;
    }

    default public void extract() throws Exception {
        Path executableFolder = this.createExecutableFolder();
        for (String resourceName : this.getResourceNames()) {
            InputStream resourceInputStream = this.getClass().getResourceAsStream("/sass-binaries/" + OSDetector.getOSName() + "/" + OSDetector.getOSArchitecture() + "/dart-sass/" + resourceName);
            if (resourceInputStream == null) {
                throw new SassCommandException(String.format("Can't extract file for system %s and architecture %s", OSDetector.getOSName(), OSDetector.getOSArchitecture()));
            }
            Path resourcePath = executableFolder.resolve(resourceName);
            if (Files.exists(resourcePath, new LinkOption[0])) continue;
            Files.copy(resourceInputStream, resourcePath, new CopyOption[0]);
            this.setResourcePermissions(resourcePath);
        }
    }

    public String[] getResourceNames();

    default public void setResourcePermissions(Path resourcePath) throws IOException {
    }
}

