/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.net;

import com.github.cleydyr.dart.net.DummyGithubLatestVersionProvider;
import com.github.cleydyr.dart.net.GithubLatestVersionProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

@Singleton
@Named
public class NetworkingGithubLatestVersionProvider
implements GithubLatestVersionProvider {
    public static final String GITHUB_DART_SASS_RELEASES_TAG_PREFIX = "https://github.com/sass/dart-sass/releases/tag/";
    public static final String GITHUB_SASS_DART_SASS_LATEST_RELEASE_URI = "https://github.com/sass/dart-sass/releases/latest";
    private Log logger = new SystemStreamLog();
    private GithubLatestVersionProvider fallbackVersionProvider = new DummyGithubLatestVersionProvider();

    @Override
    public String get() {
        try {
            HttpURLConnection connection = this.setupConnection();
            int responseCode = connection.getResponseCode();
            if (responseCode == 302) {
                String location = connection.getHeaderField("Location");
                if (location.startsWith(GITHUB_DART_SASS_RELEASES_TAG_PREFIX)) {
                    return location.substring(GITHUB_DART_SASS_RELEASES_TAG_PREFIX.length());
                }
                this.logger.warn((CharSequence)("Couldn't parse latest release location. Redirected from https://github.com/sass/dart-sass/releases/latest to " + location));
            } else {
                this.logger.warn((CharSequence)"Didn't get redirection from url https://github.com/sass/dart-sass/releases/latest");
            }
        }
        catch (IOException e) {
            this.logger.warn((CharSequence)"Error while getting latest version from https://github.com/sass/dart-sass/releases/latest", (Throwable)e);
        }
        this.logger.warn((CharSequence)("Falling back to latest known release (" + this.fallbackVersionProvider.get() + ")"));
        return this.fallbackVersionProvider.get();
    }

    public HttpURLConnection setupConnection() throws MalformedURLException, IOException, ProtocolException {
        URL url = new URL(GITHUB_SASS_DART_SASS_LATEST_RELEASE_URI);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setInstanceFollowRedirects(false);
        return connection;
    }

    public static void main(String[] args) {
        NetworkingGithubLatestVersionProvider networkingGithubLatestVersionProvider = new NetworkingGithubLatestVersionProvider();
        System.out.println(networkingGithubLatestVersionProvider.get());
    }
}

