/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.system.io;

import com.github.cleydyr.dart.release.DartSassReleaseParameter;
import com.github.cleydyr.dart.system.io.ExecutableResourcesProvider;
import com.github.cleydyr.dart.system.io.ReleaseDownloadException;
import com.github.cleydyr.dart.system.io.ReleaseDownloader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;

public abstract class FilesystemExecutableResourcesProvider
implements ExecutableResourcesProvider {
    private final File repository;
    private final ReleaseDownloader downloader;

    public FilesystemExecutableResourcesProvider(File repository, ReleaseDownloader downloader) {
        this.repository = repository;
        this.downloader = downloader;
    }

    @Override
    public InputStream getInputStream(DartSassReleaseParameter dartSassReleaseParameter, String resourceName) throws IOException {
        File release;
        File releaseDirectory = this.getReleaseDirectory(this.repository, dartSassReleaseParameter);
        if (!releaseDirectory.exists()) {
            Files.createDirectories(releaseDirectory.toPath(), new FileAttribute[0]);
        }
        if (!(release = this.getReleaseFile(releaseDirectory)).exists()) {
            this.downloadRelease(dartSassReleaseParameter, release);
        }
        return this.getResourceFromReleaseArchive(resourceName, release);
    }

    protected abstract InputStream getResourceFromReleaseArchive(String var1, File var2) throws IOException;

    protected File getReleaseFile(File releaseDirectory) {
        return new File(releaseDirectory, "release");
    }

    private void downloadRelease(DartSassReleaseParameter dartSassReleaseParameter, File destination) throws ReleaseDownloadException {
        this.downloader.download(dartSassReleaseParameter, destination);
    }

    private File getReleaseDirectory(File repository, DartSassReleaseParameter dartSassReleaseParameter) {
        return new File(new File(new File(repository, dartSassReleaseParameter.getOS()), dartSassReleaseParameter.getArch()), dartSassReleaseParameter.getVersion());
    }
}

