/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.release;

public class DartSassReleaseParameter {
    private final String os;
    private final String arch;
    private final String version;

    public DartSassReleaseParameter(String os, String arch, String version) {
        if (os == null) {
            throw new IllegalArgumentException("os can't be null");
        }
        if (arch == null) {
            throw new IllegalArgumentException("arch can't be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version can't be null");
        }
        this.os = os;
        this.arch = arch;
        this.version = version;
    }

    public String getOS() {
        return this.os;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    public String getArtifactName() {
        return String.format("dart-sass-%s-%s-%s.%s", this.version, this.os, this.arch, this.getArtifactExtension());
    }

    private String getArtifactExtension() {
        return "windows".equals(this.os) ? "zip" : "tar.gz";
    }
}

