/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.system.io;

import com.github.cleydyr.dart.release.DartSassReleaseParameter;
import com.github.cleydyr.dart.system.OSDetector;
import com.github.cleydyr.dart.system.io.DartSassExecutableExtractor;
import com.github.cleydyr.dart.system.io.ExecutableResourcesProvider;
import com.github.cleydyr.dart.system.io.utils.SystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;

public abstract class AbstractDartSassExecutableExtractor
implements DartSassExecutableExtractor {
    protected Collection<String> resourceNames;
    protected DartSassReleaseParameter dartSassReleaseParameter;
    protected ExecutableResourcesProvider executableResourcesProvider;

    public AbstractDartSassExecutableExtractor(DartSassReleaseParameter dartSassReleaseParameter, ExecutableResourcesProvider executableResourcesProvider, Collection<String> resourceNames) {
        this.dartSassReleaseParameter = dartSassReleaseParameter;
        this.executableResourcesProvider = executableResourcesProvider;
        this.resourceNames = resourceNames;
    }

    @Override
    public void extract() throws IOException {
        this.extractResourcesToFolder(this.createExecutableFolder());
    }

    private Path createExecutableFolder() throws IOException {
        Path srcDir;
        Path executableFolder = SystemUtils.getExecutableTempFolder(this.dartSassReleaseParameter);
        if (!Files.isDirectory(executableFolder, new LinkOption[0])) {
            Files.createDirectories(executableFolder, new FileAttribute[0]);
        }
        if (!Files.isDirectory(srcDir = executableFolder.resolve("src"), new LinkOption[0])) {
            Files.createDirectory(srcDir, new FileAttribute[0]);
        }
        return executableFolder;
    }

    private void extractResourcesToFolder(Path executableFolder) throws IOException {
        for (String resourceName : this.resourceNames) {
            InputStream resourceInputStream = this.getResourceInputStream("dart-sass/" + resourceName);
            try {
                if (resourceInputStream == null) {
                    throw new IOException(String.format("Can't extract file for system %s and architecture %s", OSDetector.getOSName(), OSDetector.getOSArchitecture()));
                }
                Path resourcePath = executableFolder.resolve(resourceName);
                if (Files.exists(resourcePath, new LinkOption[0])) continue;
                Files.copy(resourceInputStream, resourcePath, new CopyOption[0]);
                this.setResourcePermissions(resourcePath);
            }
            finally {
                if (resourceInputStream == null) continue;
                resourceInputStream.close();
            }
        }
    }

    private InputStream getResourceInputStream(String resourceName) throws IOException {
        return this.executableResourcesProvider.getInputStream(this.dartSassReleaseParameter, resourceName);
    }

    abstract void setResourcePermissions(Path var1) throws IOException;
}

