/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.dart.command.files;

import com.github.cleydyr.dart.command.files.FileCounter;
import com.github.cleydyr.dart.command.files.FileCounterException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class DefaultFileCounter
implements FileCounter {
    private static final String[] ALLOWED_EXTENSIONS_DIFFERENT_FOLDERS = new String[]{".css", ".sass", ".scss"};
    private static final String[] ALLOWED_EXTENSIONS_SAME_FOLDER = new String[]{".sass", ".scss"};

    @Override
    public long getProcessableFileCount(Path inputFolderPath, Path outputFolderPath) throws FileCounterException {
        long l;
        block8: {
            Stream<Path> walk = Files.walk(inputFolderPath, new FileVisitOption[0]);
            try {
                l = ((Stream)walk.parallel()).filter(p -> !Files.isDirectory(p, new LinkOption[0])).map(Path::toString).filter(inputFolderPath.equals(outputFolderPath) ? this::hasAllowedExtensionSameFolder : this::hasAllowedExtensionDifferentFolders).count();
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new FileCounterException("Can't list folder " + inputFolderPath, e);
                }
            }
            walk.close();
        }
        return l;
    }

    @Override
    public boolean hasAllowedExtensionSameFolder(String fileName) {
        return this.hasAllowedExtension(fileName, ALLOWED_EXTENSIONS_SAME_FOLDER);
    }

    @Override
    public boolean hasAllowedExtensionDifferentFolders(String fileName) {
        return this.hasAllowedExtension(fileName, ALLOWED_EXTENSIONS_DIFFERENT_FOLDERS);
    }

    public boolean hasAllowedExtension(String fileName, String ... allowedExtensions) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can't be null");
        }
        return Arrays.stream(allowedExtensions).anyMatch(fileName::endsWith);
    }
}

