/*
 * Decompiled with CFR 0.152.
 */
package com.github.cleydyr.maven.plugin;

import com.github.cleydyr.dart.command.SassCommand;
import com.github.cleydyr.dart.command.builder.SassCommandBuilder;
import com.github.cleydyr.dart.command.enums.SourceMapURLs;
import com.github.cleydyr.dart.command.enums.Style;
import com.github.cleydyr.dart.command.exception.SassCommandException;
import com.github.cleydyr.dart.command.factory.SassCommandBuilderFactory;
import com.github.cleydyr.dart.command.files.FileCounter;
import com.github.cleydyr.dart.command.files.FileCounterException;
import com.github.cleydyr.dart.net.GithubLatestVersionProvider;
import com.github.cleydyr.dart.release.DartSassReleaseParameter;
import com.github.cleydyr.dart.system.OSDetector;
import com.github.cleydyr.dart.system.io.DartSassExecutableExtractor;
import com.github.cleydyr.dart.system.io.DefaultCachedFilesDirectoryProviderFactory;
import com.github.cleydyr.dart.system.io.exception.DartSassExecutableExtractorException;
import com.github.cleydyr.dart.system.io.factory.DartSassExecutableExtractorFactory;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;

@Mojo(name="compile-sass", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, threadSafe=true)
public class CompileSassMojo
extends AbstractMojo {
    private FileCounter fileCounter;
    protected SassCommandBuilder sassCommandBuilder;
    protected DartSassExecutableExtractorFactory dartSassExecutableExtractorFactory;
    protected GithubLatestVersionProvider githubLatestVersionProvider;
    protected Supplier<File> cachedFilesDirectoryProvider;
    private DartSassReleaseParameter dartSassReleaseParameter;
    private Proxy proxy;
    private static final Object LOCK = new Object();
    @Parameter(defaultValue="src/main/sass")
    private File inputFolder;
    @Parameter(property="project.build.directory")
    private File outputFolder;
    @Parameter
    private List<File> loadPaths;
    @Parameter(defaultValue="EXPANDED")
    private Style style;
    @Parameter(defaultValue="false")
    private boolean noCharset;
    @Parameter(defaultValue="true")
    private boolean errorCSS;
    @Parameter(defaultValue="false")
    private boolean update;
    @Parameter(defaultValue="false")
    private boolean noSourceMap;
    @Parameter(defaultValue="RELATIVE")
    private SourceMapURLs sourceMapURLs;
    @Parameter(defaultValue="false")
    private boolean embedSources;
    @Parameter(defaultValue="false")
    private boolean embedSourceMap;
    @Parameter(defaultValue="false")
    private boolean stopOnError;
    @Parameter(defaultValue="true")
    private boolean color;
    @Parameter(defaultValue="false")
    private boolean noUnicode;
    @Parameter(defaultValue="false")
    private boolean quiet;
    @Parameter(defaultValue="false")
    private boolean quietDeps;
    @Parameter(defaultValue="false")
    private boolean trace;
    @Parameter
    private String version;
    @Parameter
    private String arch;
    @Parameter
    private String os;
    @Parameter
    private File cachedFilesDirectory;

    @Inject
    public CompileSassMojo(FileCounter fileCounter, SassCommandBuilderFactory sassCommandBuilderFactory, DartSassExecutableExtractorFactory dartSassExecutableExtractorFactory, GithubLatestVersionProvider githubLatestVersionProvider, DefaultCachedFilesDirectoryProviderFactory cachedFilesDirectoryProviderFactory, MavenSession mavenSession) {
        this.fileCounter = fileCounter;
        this.sassCommandBuilder = sassCommandBuilderFactory.getCommanderBuilder();
        this.dartSassExecutableExtractorFactory = dartSassExecutableExtractorFactory;
        this.githubLatestVersionProvider = githubLatestVersionProvider;
        this.cachedFilesDirectoryProvider = cachedFilesDirectoryProviderFactory.get();
        if (mavenSession == null || mavenSession.getSettings() == null || mavenSession.getSettings().getActiveProxy() == null) {
            return;
        }
        this.proxy = mavenSession.getSettings().getActiveProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.validateProxyHostSyntax();
        this.verifyDefaultParameters();
        this.unsetIncompatibleOptions();
        Object object = LOCK;
        synchronized (object) {
            this.extractExecutable();
        }
        SassCommand sassCommand = this.buildSassCommand();
        try {
            Instant start = Instant.now();
            sassCommand.execute();
            Instant finish = Instant.now();
            long elapsedTime = Duration.between(start, finish).toMillis();
            try {
                long fileCount = this.fileCounter.getProcessableFileCount(this.inputFolder.toPath(), this.outputFolder.toPath());
                this.getLog().info((CharSequence)("Compiled " + fileCount + " files in " + elapsedTime + " ms"));
            }
            catch (FileCounterException fileCounterException) {
                throw new MojoExecutionException("Error while obtaining file count: ", (Exception)fileCounterException);
            }
        }
        catch (SassCommandException sassCommandException) {
            throw new MojoExecutionException("Can't execute SASS command", (Exception)sassCommandException);
        }
    }

    protected void verifyDefaultParameters() throws MojoExecutionException {
        if (this.os == null) {
            this.os = OSDetector.getOSName();
            this.getLog().info((CharSequence)("Auto-detected operating system: " + this.os));
        } else if (!OSDetector.isAcceptedOSName(this.os)) {
            this.getLog().warn((CharSequence)("os value " + this.os + " is not among the accepted values: " + OSDetector.ACCEPTED_OSES));
        }
        if (this.arch == null) {
            this.arch = OSDetector.getOSArchitecture();
            this.getLog().info((CharSequence)("Auto-detected operating system architecture: " + this.arch));
        } else if (!OSDetector.isAcceptedArchitecture(this.arch)) {
            this.getLog().warn((CharSequence)("architecture value " + this.arch + " is not among the accepted values: " + OSDetector.ACCEPTED_ARCHITECTURES));
        }
        if (this.version == null) {
            this.version = this.githubLatestVersionProvider.get(this.os, this.arch);
            this.getLog().info((CharSequence)("Auto-detected latest version: " + this.version));
        }
        if (this.cachedFilesDirectory == null) {
            this.cachedFilesDirectory = this.cachedFilesDirectoryProvider.get();
            this.getLog().info((CharSequence)("Auto-detected cached files directory: " + this.cachedFilesDirectory));
        }
        this.dartSassReleaseParameter = new DartSassReleaseParameter(this.os, this.arch, this.version);
    }

    public void unsetIncompatibleOptions() {
        if (this.noSourceMap) {
            this.sourceMapURLs = null;
            this.embedSourceMap = false;
            this.embedSources = false;
        }
    }

    public void extractExecutable() throws MojoExecutionException {
        DartSassExecutableExtractor dartSassExecutableExtractor = this.dartSassExecutableExtractorFactory.getDartSassExecutableExtractor(this.dartSassReleaseParameter, this.cachedFilesDirectory, this.proxy);
        try {
            dartSassExecutableExtractor.extract();
        }
        catch (DartSassExecutableExtractorException exception) {
            throw new MojoExecutionException("Unable to extract sass executable", (Exception)exception);
        }
    }

    private void validateProxyHostSyntax() throws MojoExecutionException {
        if (this.proxy == null) {
            this.getLog().info((CharSequence)"Proxy not set.");
            return;
        }
        this.getLog().info((CharSequence)("Using proxy: " + this.proxy.getProtocol() + "://" + this.proxy.getHost() + ":" + this.proxy.getPort()));
        if (this.proxy.getNonProxyHosts() != null) {
            this.getLog().info((CharSequence)("Non proxy hosts: " + this.proxy.getNonProxyHosts()));
        }
    }

    protected SassCommand buildSassCommand() throws MojoExecutionException {
        if (this.loadPaths != null) {
            for (File loadPath : this.loadPaths) {
                this.sassCommandBuilder.withLoadPath(loadPath.toPath());
            }
        }
        this.setOptions();
        Path inputFolderPath = this.inputFolder.toPath();
        this.sassCommandBuilder.withPaths(inputFolderPath, this.outputFolder.toPath());
        try {
            return this.sassCommandBuilder.build(this.dartSassReleaseParameter);
        }
        catch (SassCommandException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    protected void setOptions() {
        this.sassCommandBuilder.withStyle(this.style);
        this.sassCommandBuilder.withNoCharset(this.noCharset);
        this.sassCommandBuilder.withErrorCSS(this.errorCSS);
        this.sassCommandBuilder.withUpdate(this.update);
        this.sassCommandBuilder.withNoSourceMap(this.noSourceMap);
        this.sassCommandBuilder.withSourceMapURLs(this.sourceMapURLs);
        this.sassCommandBuilder.withEmbedSources(this.embedSources);
        this.sassCommandBuilder.withEmbedSourceMap(this.embedSourceMap);
        this.sassCommandBuilder.withStopOnError(this.stopOnError);
        this.sassCommandBuilder.withColor(this.color);
        this.sassCommandBuilder.withNoUnicode(this.noUnicode);
        this.sassCommandBuilder.withQuiet(this.quiet);
        this.sassCommandBuilder.withQuietDeps(this.quietDeps);
        this.sassCommandBuilder.withTrace(this.trace);
    }

    public File getInputFolder() {
        return this.inputFolder;
    }

    public void setInputFolder(File inputFolder) {
        this.inputFolder = inputFolder;
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(File outputFolder) {
        this.outputFolder = outputFolder;
    }

    public List<File> getLoadPaths() {
        return this.loadPaths;
    }

    public void setLoadPaths(List<File> loadPaths) {
        this.loadPaths = loadPaths;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean isNoCharset() {
        return this.noCharset;
    }

    public void setNoCharset(boolean noCharset) {
        this.noCharset = noCharset;
    }

    public boolean isErrorCSS() {
        return this.errorCSS;
    }

    public void setErrorCSS(boolean errorCSS) {
        this.errorCSS = errorCSS;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    public boolean isNoSourceMap() {
        return this.noSourceMap;
    }

    public void setNoSourceMap(boolean noSourceMap) {
        this.noSourceMap = noSourceMap;
    }

    public SourceMapURLs getSourceMapURLs() {
        return this.sourceMapURLs;
    }

    public void setSourceMapURLs(SourceMapURLs sourceMapURLs) {
        this.sourceMapURLs = sourceMapURLs;
    }

    public boolean isEmbedSources() {
        return this.embedSources;
    }

    public void setEmbedSources(boolean embedSources) {
        this.embedSources = embedSources;
    }

    public boolean isEmbedSourceMap() {
        return this.embedSourceMap;
    }

    public void setEmbedSourceMap(boolean embedSourceMap) {
        this.embedSourceMap = embedSourceMap;
    }

    public boolean isStopOnError() {
        return this.stopOnError;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public boolean isColor() {
        return this.color;
    }

    public void setColor(boolean color) {
        this.color = color;
    }

    public boolean isNoUnicode() {
        return this.noUnicode;
    }

    public void setNoUnicode(boolean noUnicode) {
        this.noUnicode = noUnicode;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuietDeps() {
        return this.quietDeps;
    }

    public void setQuietDeps(boolean quietDeps) {
        this.quietDeps = quietDeps;
    }

    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }
}

