/*
 * Decompiled with CFR 0.152.
 */
package io.pointberry.eventtracker;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class PointBerryImpressionTracker {
    private static final String TAG = PointBerryImpressionTracker.class.getSimpleName();
    private static final String BASE_URL = "https://impression.pointberry.io/beacon.png";
    private static Context appContext;

    public PointBerryImpressionTracker(Context context) {
        appContext = context;
    }

    public void logImpression(String inventoryId) {
        this.logImpression(inventoryId, false);
    }

    public void logImpression(String inventoryId, boolean development) {
        ImpressionTask impTask = new ImpressionTask(inventoryId, development);
        impTask.execute(new Void[0]);
    }

    private static class ImpressionTask
    extends AsyncTask<Void, Void, String> {
        private final String inventoryId;
        private final boolean development;

        ImpressionTask(String inventoryId, boolean development) {
            this.inventoryId = inventoryId;
            this.development = development;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected String doInBackground(Void ... params) {
            String msg;
            int responseCode;
            String adId;
            try {
                AdvertisingIdClient.Info adIdInfo = AdvertisingIdClient.getAdvertisingIdInfo((Context)appContext);
                adId = adIdInfo.getId();
            }
            catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException e) {
                Log.e((String)TAG, (String)"Failed to get advertising ID");
                return null;
            }
            String url = "https://impression.pointberry.io/beacon.png?ii=" + this.inventoryId + "&adid=" + adId + "&ti=" + System.currentTimeMillis() / 1000L + "&cb=" + new Random().nextInt();
            HttpURLConnection conn = null;
            try {
                SSLContext sc = SSLContext.getInstance("TLS");
                sc.init(null, null, new SecureRandom());
                conn = (HttpsURLConnection)new URL(url).openConnection();
                ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
                conn.setRequestMethod("GET");
                conn.connect();
                responseCode = conn.getResponseCode();
            }
            catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
                Log.e((String)TAG, (String)("Failed to log ad impression with " + e.getClass().getName()));
                String string = null;
                return string;
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
            if (responseCode == 200) {
                msg = "Successfully logged ad impression for inventory ID " + this.inventoryId + " and advertising ID " + adId;
                if (this.development) {
                    Log.i((String)TAG, (String)msg);
                } else {
                    Log.d((String)TAG, (String)msg);
                }
            } else {
                msg = "Failed to log ad impression with HTTP status code " + responseCode;
                Log.e((String)TAG, (String)msg);
            }
            return msg;
        }
    }
}

