/*
 * Decompiled with CFR 0.152.
 */
package ethereum.cryptography;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class CellsAndProofs {
    public byte[][] cells;
    public byte[][] proofs;

    public CellsAndProofs(byte[][] cells, byte[][] proofs) {
        this.cells = cells;
        this.proofs = proofs;
    }

    public byte[][] getCells() {
        return this.cells;
    }

    public byte[][] getProofs() {
        return this.proofs;
    }

    public static CellsAndProofs of(byte[][] cells, byte[][] proofs) {
        return new CellsAndProofs(cells, proofs);
    }

    public byte[] toBytes() {
        int cellsLength = Arrays.stream(this.cells).mapToInt(cell -> ((byte[])cell).length).sum();
        int proofsLength = Arrays.stream(this.proofs).mapToInt(proof -> ((byte[])proof).length).sum();
        int totalLength = cellsLength + proofsLength;
        ByteBuffer buffer = ByteBuffer.allocate(totalLength);
        Arrays.stream(this.cells).forEach(buffer::put);
        Arrays.stream(this.proofs).forEach(buffer::put);
        return buffer.array();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + Arrays.deepHashCode((Object[])this.cells);
        result = prime * result + Arrays.deepHashCode((Object[])this.proofs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CellsAndProofs other = (CellsAndProofs)obj;
        return Arrays.deepEquals((Object[])this.cells, (Object[])other.cells) && Arrays.deepEquals((Object[])this.proofs, (Object[])other.proofs);
    }
}

