/*
 * Decompiled with CFR 0.152.
 */
package ethereum.cryptography;

import ethereum.cryptography.CellsAndProofs;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class LibEthKZG
implements AutoCloseable {
    public static final int BYTES_PER_COMMITMENT = 48;
    public static final int BYTES_PER_PROOF = 48;
    public static final int BYTES_PER_FIELD_ELEMENT = 32;
    public static final int BYTES_PER_BLOB = 131072;
    public static final int MAX_NUM_COLUMNS = 128;
    public static final int BYTES_PER_CELL = 2048;
    private long contextPtr;
    private static volatile boolean libraryLoaded = false;
    private static final Object libraryLock = new Object();
    private static final String LIBRARY_NAME = "java_eth_kzg";
    private static final String PLATFORM_NATIVE_LIBRARY_NAME = System.mapLibraryName("java_eth_kzg");

    public LibEthKZG() {
        LibEthKZG.ensureLibraryLoaded();
        boolean usePrecomp = true;
        long numThreads = 1L;
        this.contextPtr = LibEthKZG.DASContextNew(usePrecomp, numThreads);
    }

    public LibEthKZG(boolean usePrecomp, long numThreads) {
        LibEthKZG.ensureLibraryLoaded();
        this.contextPtr = LibEthKZG.DASContextNew(usePrecomp, numThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLibraryLoaded() {
        if (!libraryLoaded) {
            Object object = libraryLock;
            synchronized (object) {
                if (!libraryLoaded) {
                    LibEthKZG.loadNativeLibrary();
                    libraryLoaded = true;
                }
            }
        }
    }

    @Override
    public void close() {
        this.destroy();
    }

    public void destroy() {
        if (this.contextPtr != 0L) {
            LibEthKZG.DASContextDestroy(this.contextPtr);
            this.contextPtr = 0L;
        }
    }

    private void checkContextHasNotBeenFreed() {
        if (this.contextPtr == 0L) {
            throw new IllegalStateException("KZG context context has been destroyed");
        }
    }

    public byte[] blobToKZGCommitment(byte[] blob) {
        this.checkContextHasNotBeenFreed();
        return LibEthKZG.blobToKZGCommitment(this.contextPtr, blob);
    }

    public CellsAndProofs computeCellsAndKZGProofs(byte[] blob) {
        this.checkContextHasNotBeenFreed();
        CellsAndProofs cellsAndProofs = LibEthKZG.computeCellsAndKZGProofs(this.contextPtr, blob);
        return cellsAndProofs;
    }

    public boolean verifyCellKZGProofBatch(byte[][] commitmentsArr, long[] cellIndices, byte[][] cellsArr, byte[][] proofsArr) {
        this.checkContextHasNotBeenFreed();
        return LibEthKZG.verifyCellKZGProofBatch(this.contextPtr, commitmentsArr, cellIndices, cellsArr, proofsArr);
    }

    public CellsAndProofs recoverCellsAndKZGProofs(long[] cellIDs, byte[][] cellsArr) {
        this.checkContextHasNotBeenFreed();
        return LibEthKZG.recoverCellsAndKZGProofs(this.contextPtr, cellIDs, cellsArr);
    }

    private static native long DASContextNew(boolean var0, long var1);

    private static native void DASContextDestroy(long var0);

    private static native CellsAndProofs computeCellsAndKZGProofs(long var0, byte[] var2);

    private static native byte[] blobToKZGCommitment(long var0, byte[] var2);

    private static native boolean verifyCellKZGProofBatch(long var0, byte[][] var2, long[] var3, byte[][] var4, byte[][] var5);

    private static native CellsAndProofs recoverCellsAndKZGProofs(long var0, long[] var2, byte[][] var3);

    private static String getNormalizedArchitecture() {
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch.equals("x86_64") || osArch.equals("amd64")) {
            return "x86_64";
        }
        if (osArch.equals("aarch64") || osArch.equals("arm64")) {
            return "aarch64";
        }
        return osArch;
    }

    private static void loadNativeLibrary() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = LibEthKZG.getNormalizedArchitecture();
        String libraryResourcePath = null;
        System.out.println("name: " + osName + " arch:" + osArch + " platform: " + PLATFORM_NATIVE_LIBRARY_NAME);
        if (osName.contains("win")) {
            if (osArch.contains("x86_64")) {
                libraryResourcePath = "/x86_64-pc-windows-gnu/" + PLATFORM_NATIVE_LIBRARY_NAME;
            } else if (!osArch.contains("x86") && osArch.contains("aarch64")) {
                // empty if block
            }
        } else if (osName.contains("mac")) {
            if (osArch.contains("x86_64")) {
                libraryResourcePath = "/x86_64-apple-darwin/" + PLATFORM_NATIVE_LIBRARY_NAME;
            } else if (osArch.contains("aarch64")) {
                libraryResourcePath = "/aarch64-apple-darwin/" + PLATFORM_NATIVE_LIBRARY_NAME;
            }
        } else if (osName.contains("linux")) {
            if (osArch.contains("x86_64")) {
                libraryResourcePath = "/x86_64-unknown-linux-gnu/" + PLATFORM_NATIVE_LIBRARY_NAME;
            } else if (osArch.contains("aarch64")) {
                libraryResourcePath = "/aarch64-unknown-linux-gnu/" + PLATFORM_NATIVE_LIBRARY_NAME;
            }
        }
        if (libraryResourcePath == null) {
            throw new UnsupportedOperationException("Unsupported OS or architecture: " + osName + ", " + osArch);
        }
        InputStream libraryResource = LibEthKZG.class.getResourceAsStream(libraryResourcePath);
        if (libraryResource == null) {
            try {
                System.loadLibrary(LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError __) {
                String exceptionMessage = String.format("Couldn't load native library (%s). It wasn't available at %s or the library path.", LIBRARY_NAME, libraryResourcePath);
                throw new RuntimeException(exceptionMessage);
            }
        }
        try {
            Path tempDir = Files.createTempDirectory("java_eth_kzg@", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            Path tempDll = tempDir.resolve(PLATFORM_NATIVE_LIBRARY_NAME);
            tempDll.toFile().deleteOnExit();
            Files.copy(libraryResource, tempDll, StandardCopyOption.REPLACE_EXISTING);
            libraryResource.close();
            System.load(tempDll.toString());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

