/*
 * Decompiled with CFR 0.152.
 */
package ethereum.cryptography;

import java.nio.ByteBuffer;
import java.util.Arrays;

public class Cells {
    public byte[][] cells;

    public Cells(byte[][] cells) {
        this.cells = cells;
    }

    public byte[][] getCells() {
        return this.cells;
    }

    public static Cells of(byte[][] cells) {
        return new Cells(cells);
    }

    public byte[] toBytes() {
        int cellsLength = Arrays.stream(this.cells).mapToInt(cell -> ((byte[])cell).length).sum();
        ByteBuffer buffer = ByteBuffer.allocate(cellsLength);
        Arrays.stream(this.cells).forEach(buffer::put);
        return buffer.array();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.deepHashCode((Object[])this.cells);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cells other = (Cells)obj;
        return Arrays.deepEquals((Object[])this.cells, (Object[])other.cells);
    }
}

