/*
 * Decompiled with CFR 0.152.
 */
package verkle.cryptography;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class LibIpaMultipoint {
    private static volatile boolean ENABLED;
    private static final Object libraryLock;
    private static final String LIBRARY_NAME = "java_verkle_cryptography";

    public static native byte[] commit(byte[] var0);

    public static native byte[] addCommitment(byte[] var0, byte[] var1);

    public static native byte[] commitAsCompressed(byte[] var0);

    public static native byte[] updateSparse(byte[] var0, byte[] var1, byte[] var2, byte[] var3);

    public static native byte[] compress(byte[] var0);

    public static native byte[] compressMany(byte[] var0);

    public static native byte[] hash(byte[] var0);

    public static native byte[] hashMany(byte[] var0);

    public static native boolean verifyPreStateRoot(byte[][] var0, byte[][] var1, byte[][] var2, byte[][] var3, byte[][] var4, byte[][] var5, byte[] var6, byte[] var7, byte[] var8, byte[] var9);

    private static String getNormalizedArchitecture() {
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osArch.equals("x86_64") || osArch.equals("amd64")) {
            return "x86_64";
        }
        if (osArch.equals("aarch64") || osArch.equals("arm64")) {
            return "aarch64";
        }
        return osArch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureLibraryLoaded() {
        if (!ENABLED) {
            Object object = libraryLock;
            synchronized (object) {
                if (!ENABLED) {
                    LibIpaMultipoint.loadNativeLibrary();
                    ENABLED = true;
                }
            }
        }
    }

    private static void loadNativeLibrary() {
        String PLATFORM_NATIVE_LIBRARY_NAME = System.mapLibraryName(LIBRARY_NAME);
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = LibIpaMultipoint.getNormalizedArchitecture();
        String libraryResourcePath = null;
        if (osName.contains("win")) {
            if (osArch.contains("x86_64")) {
                libraryResourcePath = "/x86_64-pc-windows-gnu/" + PLATFORM_NATIVE_LIBRARY_NAME;
            } else if (!osArch.contains("x86") && osArch.contains("aarch64")) {
                // empty if block
            }
        } else if (osName.contains("mac")) {
            if (osArch.contains("x86_64")) {
                libraryResourcePath = "/x86_64-apple-darwin/" + PLATFORM_NATIVE_LIBRARY_NAME;
            } else if (osArch.contains("aarch64")) {
                libraryResourcePath = "/aarch64-apple-darwin/" + PLATFORM_NATIVE_LIBRARY_NAME;
            }
        } else if (osName.contains("linux")) {
            if (osArch.contains("x86_64")) {
                libraryResourcePath = "/x86_64-unknown-linux-gnu/" + PLATFORM_NATIVE_LIBRARY_NAME;
            } else if (osArch.contains("aarch64")) {
                libraryResourcePath = "/aarch64-unknown-linux-gnu/" + PLATFORM_NATIVE_LIBRARY_NAME;
            }
        }
        if (libraryResourcePath == null) {
            throw new UnsupportedOperationException("Unsupported OS or architecture: " + osName + ", " + osArch);
        }
        InputStream libraryResource = LibIpaMultipoint.class.getResourceAsStream(libraryResourcePath);
        if (libraryResource == null) {
            try {
                System.loadLibrary(LIBRARY_NAME);
            }
            catch (UnsatisfiedLinkError __) {
                String exceptionMessage = String.format("Couldn't load native library (%s). It wasn't available at %s or the library path.", LIBRARY_NAME, libraryResourcePath);
                throw new RuntimeException(exceptionMessage);
            }
        }
        try {
            Path tempDir = Files.createTempDirectory("java_verkle_cryptography@", new FileAttribute[0]);
            tempDir.toFile().deleteOnExit();
            Path tempDll = tempDir.resolve(PLATFORM_NATIVE_LIBRARY_NAME);
            tempDll.toFile().deleteOnExit();
            Files.copy(libraryResource, tempDll, StandardCopyOption.REPLACE_EXISTING);
            libraryResource.close();
            System.load(tempDll.toString());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    static {
        libraryLock = new Object();
        LibIpaMultipoint.ensureLibraryLoaded();
    }
}

