/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc;

import io.github.crizzis.codenarc.parser.CodeNarcAnalysis;
import io.github.crizzis.codenarc.parser.CodeNarcXmlParser;
import io.github.crizzis.codenarc.report.CodeNarcReportGenerator;
import java.io.File;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="codenarc", defaultPhase=LifecyclePhase.SITE)
@Execute(goal="verify")
public class CodeNarcReportMojo
extends AbstractMavenReport {
    private final CodeNarcXmlParser xmlParser;
    private final CodeNarcReportGenerator reportGenerator;
    @Parameter(property="codenarc.xmlOutputDirectory", defaultValue="${project.build.directory}")
    private File xmlOutputDirectory;
    @Parameter(property="codenarc.skip", defaultValue="false")
    private boolean skip;

    @Inject
    public CodeNarcReportMojo(CodeNarcXmlParser xmlParser, CodeNarcReportGenerator reportGenerator) {
        this.xmlParser = xmlParser;
        this.reportGenerator = reportGenerator;
    }

    public boolean canGenerateReport() {
        File xmlOutputFile = this.getXmlOutputFile();
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Plugin execution skipped");
            return false;
        }
        if (!xmlOutputFile.exists() || !xmlOutputFile.canRead()) {
            this.getLog().info((CharSequence)String.format("CodeNarc report %s not found - skipping HTML report generation", xmlOutputFile.getPath()));
            return false;
        }
        return true;
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        CodeNarcAnalysis analysis = this.parseAnalysis();
        this.generateReport(analysis, locale);
    }

    private void generateReport(CodeNarcAnalysis analysis, Locale locale) {
        this.getLog().info((CharSequence)("Report locale set to " + locale));
        this.reportGenerator.generate(analysis, this.getSink(), locale);
    }

    public String getOutputName() {
        return "codenarc";
    }

    public String getName(Locale locale) {
        return this.getCodeNarcMessages(locale).getString("report.codenarc.name");
    }

    public String getDescription(Locale locale) {
        return this.getCodeNarcMessages(locale).getString("report.codenarc.description");
    }

    private ResourceBundle getCodeNarcMessages(Locale locale) {
        return ResourceBundle.getBundle("codenarc-messages", locale);
    }

    private CodeNarcAnalysis parseAnalysis() throws MavenReportException {
        File outputFile = this.getXmlOutputFile();
        try {
            this.getLog().info((CharSequence)"CodeNarc report XML found, parsing");
            CodeNarcAnalysis analysis = this.xmlParser.parse(outputFile);
            this.getLog().info((CharSequence)"Parsing completed");
            return analysis;
        }
        catch (CodeNarcXmlParser.XmlParserException e) {
            throw new MavenReportException(String.format("Could not parse: %s", outputFile.getAbsolutePath()), (Exception)e);
        }
    }

    private File getXmlOutputFile() {
        return new File(this.getXmlOutputDirectory(), "CodeNarc.xml");
    }

    public CodeNarcXmlParser getXmlParser() {
        return this.xmlParser;
    }

    public CodeNarcReportGenerator getReportGenerator() {
        return this.reportGenerator;
    }

    public File getXmlOutputDirectory() {
        return this.xmlOutputDirectory;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setXmlOutputDirectory(File xmlOutputDirectory) {
        this.xmlOutputDirectory = xmlOutputDirectory;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

