/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc;

import io.github.crizzis.codenarc.AnalysisScopeConfig;
import io.github.crizzis.codenarc.FileSetResolver;
import io.github.crizzis.codenarc.integration.GroovyCompilerPluginIntegration;
import io.github.crizzis.codenarc.parser.CodeNarcXmlParser;
import io.github.crizzis.codenarc.runner.CodeNarcConfig;
import io.github.crizzis.codenarc.runner.CodeNarcRunnerFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codenarc.CodeNarcRunner;
import org.codenarc.results.Results;

@Mojo(name="verify", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.TEST)
public class CodeNarcVerifyMojo
extends AbstractMojo
implements AnalysisScopeConfig {
    private static final int PRIORITY_ONE = 1;
    private static final int PRIORITY_TWO = 2;
    private static final int PRIORITY_THREE = 3;
    private final CodeNarcRunnerFactory codeNarcRunnerFactory;
    private final CodeNarcXmlParser codeNarcXmlParser;
    private final Collection<GroovyCompilerPluginIntegration> compilerIntegrations;
    @Parameter(property="codenarc.xmlOutputDirectory", defaultValue="${project.build.directory}")
    private File xmlOutputDirectory;
    @Parameter(property="codenarc.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="codenarc.includes", defaultValue="**/*.groovy")
    private List<String> includes = List.of("**/*.groovy");
    @Parameter(property="codenarc.excludes")
    private List<String> excludes;
    @Parameter(property="codenarc.defaultRuleSets", defaultValue="rulesets/basic.xml,rulesets/exceptions.xml,rulesets/imports.xml")
    private List<String> defaultRuleSets = List.of("rulesets/basic.xml", "rulesets/exceptions.xml", "rulesets/imports.xml");
    @Parameter(property="codenarc.additionalRulesets")
    private File[] additionalRuleSets = new File[0];
    @Parameter(property="codenarc.sources")
    private FileSet[] sources;
    @Parameter(property="codenarc.testSources")
    private FileSet[] testSources;
    @Parameter(property="codenarc.includeTests", defaultValue="false")
    private boolean includeTests;
    @Parameter(property="codenarc.includeMain", defaultValue="true")
    private boolean includeMain;
    @Parameter(property="codenarc.maxPriority1Violations", defaultValue="-1")
    private int maxPriority1Violations;
    @Parameter(property="codenarc.maxPriority2Violations", defaultValue="-1")
    private int maxPriority2Violations;
    @Parameter(property="codenarc.maxPriority3Violations", defaultValue="-1")
    private int maxPriority3Violations;
    @Parameter(property="codenarc.ignoreExistingReport", defaultValue="true")
    private boolean ignoreExistingReport;
    @Parameter(defaultValue="true", property="codenarc.xmlOutput", required=true)
    boolean xmlOutput;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;

    @Inject
    public CodeNarcVerifyMojo(CodeNarcRunnerFactory codeNarcRunnerFactory, CodeNarcXmlParser codeNarcXmlParser, Collection<GroovyCompilerPluginIntegration> compilerIntegrations) {
        this.codeNarcRunnerFactory = codeNarcRunnerFactory;
        this.codeNarcXmlParser = codeNarcXmlParser;
        this.compilerIntegrations = compilerIntegrations;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.shouldRun()) {
            return;
        }
        Results results = this.obtainCodeNarcResults();
        this.verifyViolationsBelowThreshold(results);
    }

    private Results obtainCodeNarcResults() throws MojoExecutionException {
        if (!this.isIgnoreExistingReport() && this.getXmlOutputFile().exists()) {
            return this.reconstructFromExistingReport();
        }
        return this.tryExecuteCheck(this.obtainCodeNarcRunner());
    }

    private Results reconstructFromExistingReport() throws MojoExecutionException {
        File outputFile = this.getXmlOutputFile();
        try {
            this.getLog().info((CharSequence)"Existing CodeNarc report XML found, parsing");
            Results results = this.codeNarcXmlParser.parse(outputFile).getResults();
            this.getLog().info((CharSequence)String.format("Parsing completed: (p1=%d; p2=%d; p3=%d)", results.getNumberOfViolationsWithPriority(1, true), results.getNumberOfViolationsWithPriority(2, true), results.getNumberOfViolationsWithPriority(3, true)));
            return results;
        }
        catch (CodeNarcXmlParser.XmlParserException e) {
            throw new MojoExecutionException(String.format("Could not parse: %s", outputFile.getAbsolutePath()), (Exception)e);
        }
    }

    private CodeNarcRunner obtainCodeNarcRunner() throws MojoExecutionException {
        CodeNarcConfig config = CodeNarcConfig.builder().projectName(this.project.getName()).outputFile(this.getXmlOutputFile()).fileSets(this.resolveFileSets()).ruleSets(this.resolveRuleSets()).generateXmlReport(this.isXmlOutput()).build();
        return this.codeNarcRunnerFactory.newCodeNarcRunner(config);
    }

    private File getXmlOutputFile() {
        return new File(this.getXmlOutputDirectory(), "CodeNarc.xml");
    }

    private List<String> resolveRuleSets() throws MojoExecutionException {
        List<String> rulesets = Stream.concat(this.safeToStream(this.getDefaultRuleSets()), Arrays.stream(this.getAdditionalRuleSetUrls()).map(Object::toString)).collect(Collectors.toList());
        this.getLog().info((CharSequence)("Using rule sets: " + String.join((CharSequence)", ", rulesets)));
        return rulesets;
    }

    private URL[] getAdditionalRuleSetUrls() throws MojoExecutionException {
        try {
            return FileUtils.toURLs((File[])this.getAdditionalRuleSets());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Cannot convert files: %s to URLs", this.getAdditionalRuleSets()));
        }
    }

    private <T> Stream<T> safeToStream(Collection<T> collection) {
        return Optional.ofNullable(collection).stream().flatMap(Collection::stream);
    }

    private List<FileSet> resolveFileSets() {
        List<FileSet> fileSets = FileSetResolver.builder().project(this.project).session(this.session).pluginIntegrations(this.getCompilerIntegrations()).scopeConfig(this).resolveFileSets();
        this.getLog().info((CharSequence)"Resolved filesets: ");
        fileSets.forEach(fileSet -> this.getLog().info((CharSequence)fileSet.toString()));
        return fileSets;
    }

    private boolean shouldRun() {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"Plugin execution skipped");
            return false;
        }
        return true;
    }

    private void verifyViolationsBelowThreshold(Results results) throws MojoFailureException {
        this.verifyViolationsBelowThreshold(results, 1, this.getMaxPriority1Violations());
        this.verifyViolationsBelowThreshold(results, 2, this.getMaxPriority2Violations());
        this.verifyViolationsBelowThreshold(results, 3, this.getMaxPriority3Violations());
    }

    private void verifyViolationsBelowThreshold(Results results, int priority, int threshold) throws MojoFailureException {
        int actualViolations = results.getNumberOfViolationsWithPriority(priority, true);
        if (threshold >= 0 && actualViolations > threshold) {
            throw new MojoFailureException(String.format("totalPriority%dViolations exceeded threshold of %d errors with %d", priority, threshold, actualViolations));
        }
    }

    private Results tryExecuteCheck(CodeNarcRunner runner) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)"Executing CodeNarc analysis");
            return runner.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to execute CodeNarc analysis", e);
        }
    }

    public CodeNarcRunnerFactory getCodeNarcRunnerFactory() {
        return this.codeNarcRunnerFactory;
    }

    public CodeNarcXmlParser getCodeNarcXmlParser() {
        return this.codeNarcXmlParser;
    }

    public Collection<GroovyCompilerPluginIntegration> getCompilerIntegrations() {
        return this.compilerIntegrations;
    }

    public File getXmlOutputDirectory() {
        return this.xmlOutputDirectory;
    }

    public boolean isSkip() {
        return this.skip;
    }

    @Override
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    public List<String> getDefaultRuleSets() {
        return this.defaultRuleSets;
    }

    public File[] getAdditionalRuleSets() {
        return this.additionalRuleSets;
    }

    @Override
    public FileSet[] getSources() {
        return this.sources;
    }

    @Override
    public FileSet[] getTestSources() {
        return this.testSources;
    }

    @Override
    public boolean isIncludeTests() {
        return this.includeTests;
    }

    @Override
    public boolean isIncludeMain() {
        return this.includeMain;
    }

    public int getMaxPriority1Violations() {
        return this.maxPriority1Violations;
    }

    public int getMaxPriority2Violations() {
        return this.maxPriority2Violations;
    }

    public int getMaxPriority3Violations() {
        return this.maxPriority3Violations;
    }

    public boolean isIgnoreExistingReport() {
        return this.ignoreExistingReport;
    }

    public boolean isXmlOutput() {
        return this.xmlOutput;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setXmlOutputDirectory(File xmlOutputDirectory) {
        this.xmlOutputDirectory = xmlOutputDirectory;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public void setDefaultRuleSets(List<String> defaultRuleSets) {
        this.defaultRuleSets = defaultRuleSets;
    }

    public void setAdditionalRuleSets(File[] additionalRuleSets) {
        this.additionalRuleSets = additionalRuleSets;
    }

    public void setSources(FileSet[] sources) {
        this.sources = sources;
    }

    public void setTestSources(FileSet[] testSources) {
        this.testSources = testSources;
    }

    public void setIncludeTests(boolean includeTests) {
        this.includeTests = includeTests;
    }

    public void setIncludeMain(boolean includeMain) {
        this.includeMain = includeMain;
    }

    public void setMaxPriority1Violations(int maxPriority1Violations) {
        this.maxPriority1Violations = maxPriority1Violations;
    }

    public void setMaxPriority2Violations(int maxPriority2Violations) {
        this.maxPriority2Violations = maxPriority2Violations;
    }

    public void setMaxPriority3Violations(int maxPriority3Violations) {
        this.maxPriority3Violations = maxPriority3Violations;
    }

    public void setIgnoreExistingReport(boolean ignoreExistingReport) {
        this.ignoreExistingReport = ignoreExistingReport;
    }

    public void setXmlOutput(boolean xmlOutput) {
        this.xmlOutput = xmlOutput;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }
}

