/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc;

import com.google.inject.internal.util.Iterables;
import com.google.inject.internal.util.Lists;
import io.github.crizzis.codenarc.AnalysisScopeConfig;
import io.github.crizzis.codenarc.integration.GroovyCompilerPluginIntegration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.FileSet;
import org.apache.maven.project.MavenProject;

class FileSetResolver {
    private static final String DEFAULT_TEST_FILE_SET = "src/test/groovy";
    private static final String DEFAULT_MAIN_FILE_SET = "src/main/groovy";
    private final AnalysisScopeConfig scopeConfig;
    private final Collection<GroovyCompilerPluginIntegration> pluginIntegrations;
    private final MavenProject project;
    private final MavenSession session;

    List<FileSet> resolveFileSets() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.scopeConfig.isIncludeMain() ? this.filterFileSets(this.obtainEffectiveMainSources()) : Collections.emptyList(), this.scopeConfig.isIncludeTests() ? this.filterFileSets(this.obtainEffectiveTestSources()) : Collections.emptyList()));
    }

    private FileSet[] obtainEffectiveTestSources() {
        return this.obtainEffectiveSourcesFromIntegration(integration -> integration.getTestSources(this.project.getBuild(), this.session)).orElseGet(() -> this.obtainEffectiveSourcesFromConfig(this.scopeConfig.getTestSources(), DEFAULT_TEST_FILE_SET));
    }

    private Optional<FileSet[]> obtainEffectiveSourcesFromIntegration(Function<GroovyCompilerPluginIntegration, Optional<FileSet[]>> getter) {
        return this.pluginIntegrations.stream().map(getter).flatMap(Optional::stream).findAny();
    }

    private FileSet[] obtainEffectiveMainSources() {
        return this.obtainEffectiveSourcesFromIntegration(integration -> integration.getSources(this.project.getBuild(), this.session)).orElseGet(() -> this.obtainEffectiveSourcesFromConfig(this.scopeConfig.getSources(), DEFAULT_MAIN_FILE_SET));
    }

    private FileSet[] obtainEffectiveSourcesFromConfig(FileSet[] declaredSources, String defaultDirectory) {
        if (!ArrayUtils.isEmpty((Object[])declaredSources)) {
            return declaredSources;
        }
        return this.getFileSet(defaultDirectory);
    }

    private FileSet[] getFileSet(String directory) {
        FileSet defaultFileSet = new FileSet();
        defaultFileSet.setDirectory(directory);
        return new FileSet[]{defaultFileSet};
    }

    private List<FileSet> filterFileSets(FileSet[] fileSets) {
        return Arrays.stream(fileSets).map(this::getFilteredFileSetCopy).collect(Collectors.toList());
    }

    private FileSet getFilteredFileSetCopy(FileSet source) {
        FileSet copy = source.clone();
        copy.setIncludes(this.concatDistinct(copy.getIncludes(), this.scopeConfig.getIncludes()));
        copy.setExcludes(this.concatDistinct(copy.getExcludes(), this.scopeConfig.getExcludes()));
        return copy;
    }

    private List<String> concatDistinct(List<String> left, List<String> right) {
        return Stream.of(left, right).filter(Objects::nonNull).filter(Predicate.not(Collection::isEmpty)).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public static FileSetResolverBuilder builder() {
        return new FileSetResolverBuilder();
    }

    public FileSetResolver(AnalysisScopeConfig scopeConfig, Collection<GroovyCompilerPluginIntegration> pluginIntegrations, MavenProject project, MavenSession session) {
        this.scopeConfig = scopeConfig;
        this.pluginIntegrations = pluginIntegrations;
        this.project = project;
        this.session = session;
    }

    static class FileSetResolverBuilder {
        private AnalysisScopeConfig scopeConfig;
        private Collection<GroovyCompilerPluginIntegration> pluginIntegrations;
        private MavenProject project;
        private MavenSession session;

        public List<FileSet> resolveFileSets() {
            return this.build().resolveFileSets();
        }

        FileSetResolverBuilder() {
        }

        public FileSetResolverBuilder scopeConfig(AnalysisScopeConfig scopeConfig) {
            this.scopeConfig = scopeConfig;
            return this;
        }

        public FileSetResolverBuilder pluginIntegrations(Collection<GroovyCompilerPluginIntegration> pluginIntegrations) {
            this.pluginIntegrations = pluginIntegrations;
            return this;
        }

        public FileSetResolverBuilder project(MavenProject project) {
            this.project = project;
            return this;
        }

        public FileSetResolverBuilder session(MavenSession session) {
            this.session = session;
            return this;
        }

        public FileSetResolver build() {
            return new FileSetResolver(this.scopeConfig, this.pluginIntegrations, this.project, this.session);
        }

        public String toString() {
            return "FileSetResolver.FileSetResolverBuilder(scopeConfig=" + this.scopeConfig + ", pluginIntegrations=" + this.pluginIntegrations + ", project=" + this.project + ", session=" + this.session + ")";
        }
    }
}

