/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.parser;

import com.google.inject.internal.util.Iterables;
import io.github.crizzis.codenarc.parser.CodeNarcAnalysis;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.codenarc.results.DirectoryResults;
import org.codenarc.results.FileResults;
import org.codenarc.results.Results;
import org.codenarc.rule.Rule;
import org.codenarc.rule.StubRule;
import org.codenarc.rule.Violation;

class CodeNarcXmlEventConsumer {
    public static final String PATH_SEPARATOR = "/";
    private Deque<Object> currentContext = new ArrayDeque<Object>();

    CodeNarcXmlEventConsumer() {
    }

    Set<String> getIgnoredTags() {
        return Set.of("Rules", "Rule", "Description");
    }

    Set<String> getSkippedTags() {
        return Set.of("Rules");
    }

    void consumeCharacters(Characters characters) {
        this.peekAs(TextHolder.class).setValue(characters.getData());
    }

    void consumeStartCodeNarc(StartElement codeNarc) {
        CodeNarcAnalysis analysis = new CodeNarcAnalysis();
        analysis.setCodeNarcVersion(this.getVersion(codeNarc));
        this.currentContext.push(analysis);
    }

    void consumeStartReport(StartElement startElement) {
        this.peekAs(CodeNarcAnalysis.class).setReportTimestamp(this.getTimestamp(startElement));
    }

    void consumeStartProject(StartElement startElement) {
        this.peekAs(CodeNarcAnalysis.class).setProjectTitle(this.getTitle(startElement));
    }

    void consumeStartSourceDirectory(StartElement startElement) {
        this.currentContext.push(new SourceDirectoryHolder());
    }

    void consumeStartPackageSummary(StartElement packageSummary) {
        this.currentContext.push(new DirectoryResults(null, this.getTotalFiles(packageSummary).intValue()));
    }

    void consumeStartPackage(StartElement packageElement) {
        this.currentContext.push(new DirectoryResults(this.getPath(packageElement), this.getTotalFiles(packageElement).intValue()));
    }

    void consumeStartFile(StartElement file) {
        this.currentContext.push(new FileResultsHolder(this.getName(file), new ArrayList<Violation>()));
    }

    void consumeStartViolation(StartElement violationElement) {
        Violation violation = new Violation();
        violation.setLineNumber(this.getLineNumber(violationElement));
        StubRule rule = new StubRule(this.getPriority(violationElement).intValue());
        rule.setName(this.getRuleName(violationElement));
        violation.setRule((Rule)rule);
        this.currentContext.push(violation);
    }

    void consumeStartSourceLine(StartElement sourceLine) {
        this.currentContext.push(new SourceLineHolder());
    }

    void consumeStartMessage(StartElement message) {
        this.currentContext.push(new MessageHolder());
    }

    void consumeEndCodeNarc(EndElement endElement) {
        Results packageSummary = this.popAs(Results.class);
        this.peekAs(CodeNarcAnalysis.class).setResults(packageSummary);
    }

    void consumeEndReport(EndElement endElement) {
    }

    void consumeEndProject(EndElement endElement) {
    }

    void consumeEndSourceDirectory(EndElement endElement) {
        SourceDirectoryHolder sourceDirectory = this.popAs(SourceDirectoryHolder.class);
        this.peekAs(CodeNarcAnalysis.class).addSourceDirectory(sourceDirectory.getValue());
    }

    void consumeEndPackageSummary(EndElement endElement) {
    }

    void consumeEndPackage(EndElement endElement) {
        DirectoryResults child = this.popAs(DirectoryResults.class);
        DirectoryResults parent = this.peekAs(DirectoryResults.class);
        this.embedChildInParent(child, parent);
    }

    private void embedChildInParent(DirectoryResults child, DirectoryResults parent) {
        if (child.getPath().isEmpty()) {
            parent.addChild((Results)child);
            return;
        }
        DirectoryResults previous = null;
        while (parent != null) {
            previous = parent;
            parent = this.findAntecedentForPath(parent, child.getPath());
        }
        if (previous != null) {
            previous.addChild((Results)child);
        }
    }

    private DirectoryResults findAntecedentForPath(DirectoryResults parent, String path) {
        ListIterator childIterator = parent.getChildren().listIterator(parent.getChildren().size());
        while (childIterator.hasPrevious()) {
            Results previous = (Results)childIterator.previous();
            if (previous.isFile() || !this.isAntecedentForPath(previous, path)) continue;
            return (DirectoryResults)previous;
        }
        return null;
    }

    private boolean isAntecedentForPath(Results directory, String path) {
        return directory.getPath().isEmpty() || path.startsWith(directory.getPath() + PATH_SEPARATOR);
    }

    void consumeEndFile(EndElement endElement) {
        FileResultsHolder child = this.popAs(FileResultsHolder.class);
        this.peekAs(DirectoryResults.class).addChild(child.toFileResults());
    }

    void consumeEndViolation(EndElement endElement) {
        Violation child = this.popAs(Violation.class);
        this.peekAs(FileResultsHolder.class).getViolations().add(child);
    }

    void consumeEndSourceLine(EndElement endElement) {
        SourceLineHolder child = this.popAs(SourceLineHolder.class);
        this.peekAs(Violation.class).setSourceLine(child.getValue());
    }

    void consumeEndMessage(EndElement endElement) {
        MessageHolder child = this.popAs(MessageHolder.class);
        this.peekAs(Violation.class).setMessage(child.getValue());
    }

    private String getVersion(StartElement startElement) {
        return this.getAttributeValue(startElement, "version");
    }

    private String getTimestamp(StartElement startElement) {
        return this.getAttributeValue(startElement, "timestamp");
    }

    private String getTitle(StartElement startElement) {
        return this.getAttributeValue(startElement, "title");
    }

    private Integer getTotalFiles(StartElement startElement) {
        return Integer.valueOf(this.getAttributeValue(startElement, "totalFiles"));
    }

    private String getPath(StartElement startElement) {
        return this.getAttributeValue(startElement, "path");
    }

    private String getName(StartElement startElement) {
        return this.getAttributeValue(startElement, "name");
    }

    private String getRuleName(StartElement startElement) {
        return this.getAttributeValue(startElement, "ruleName");
    }

    private Integer getPriority(StartElement startElement) {
        return Integer.valueOf(this.getAttributeValue(startElement, "priority"));
    }

    private Integer getLineNumber(StartElement startElement) {
        return Integer.valueOf(this.getAttributeValue(startElement, "lineNumber"));
    }

    private String getAttributeValue(StartElement startElement, String name) {
        return startElement.getAttributeByName(new QName(name)).getValue();
    }

    private <T> T popAs(Class<T> expectedClass) {
        return (T)this.currentContext.pop();
    }

    private <T> T peekAs(Class<T> expectedClass) {
        return (T)this.currentContext.peek();
    }

    public CodeNarcAnalysis getAnalysis() {
        if (this.currentContext.size() > 1) {
            throw new IllegalStateException("Malformed XML report input, " + this.currentContext + " left to parse");
        }
        return (CodeNarcAnalysis)Iterables.getOnlyElement(this.currentContext);
    }

    private static class FileResultsHolder {
        private String name;
        private List<Violation> violations = new ArrayList<Violation>();

        public Results toFileResults() {
            return new FileResults(this.name, this.violations);
        }

        public String getName() {
            return this.name;
        }

        public List<Violation> getViolations() {
            return this.violations;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setViolations(List<Violation> violations) {
            this.violations = violations;
        }

        public FileResultsHolder(String name, List<Violation> violations) {
            this.name = name;
            this.violations = violations;
        }
    }

    private static class MessageHolder
    implements TextHolder {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }

    private static class SourceLineHolder
    implements TextHolder {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }

    private static class SourceDirectoryHolder
    implements TextHolder {
        private String value;

        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) {
            this.value = value;
        }
    }

    private static interface TextHolder {
        public void setValue(String var1);
    }
}

