/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.parser;

import io.github.crizzis.codenarc.parser.CodeNarcAnalysis;
import io.github.crizzis.codenarc.parser.CodeNarcXmlEventConsumer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

@Named
@Singleton
public class CodeNarcXmlParser {
    private static final XMLInputFactory FACTORY = XMLInputFactory.newInstance();

    public CodeNarcAnalysis parse(File xmlReport) throws XmlParserException {
        CodeNarcAnalysis codeNarcAnalysis;
        FileInputStream xmlInput = new FileInputStream(xmlReport);
        try {
            XMLEventReader xmlEventReader = FACTORY.createFilteredReader(FACTORY.createXMLEventReader(xmlInput), NodesAttributesAndCharactersOnly.filter());
            CodeNarcXmlEventProcessor processor = new CodeNarcXmlEventProcessor(xmlEventReader);
            processor.process();
            codeNarcAnalysis = processor.getAnalysis();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)xmlInput).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassCastException | IllegalArgumentException | IllegalStateException | NoSuchElementException | XMLStreamException e) {
                throw new XmlParserException(e);
            }
        }
        ((InputStream)xmlInput).close();
        return codeNarcAnalysis;
    }

    public static class XmlParserException
    extends Exception {
        public XmlParserException(Throwable cause) {
            super(cause);
        }
    }

    private static class NodesAttributesAndCharactersOnly
    implements EventFilter {
        private static final List<Integer> IGNORED_EVENTS = List.of(Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(15), Integer.valueOf(9), Integer.valueOf(5), Integer.valueOf(3), Integer.valueOf(13), Integer.valueOf(6), Integer.valueOf(14));

        private NodesAttributesAndCharactersOnly() {
        }

        public static EventFilter filter() {
            return new NodesAttributesAndCharactersOnly();
        }

        @Override
        public boolean accept(XMLEvent event) {
            if (event.isCharacters()) {
                return !event.asCharacters().isWhiteSpace();
            }
            return !IGNORED_EVENTS.contains(event.getEventType());
        }
    }

    private static class CodeNarcXmlEventProcessor {
        private final XMLEventReader eventReader;
        private final CodeNarcXmlEventConsumer consumer = new CodeNarcXmlEventConsumer();
        private final Map<String, Consumer<EndElement>> END_ELEMENT_CONSUMER_METHODS;
        private final Map<String, Consumer<StartElement>> START_ELEMENT_CONSUMER_METHODS;

        void process() throws XMLStreamException {
            while (this.eventReader.hasNext()) {
                XMLEvent xmlEvent = this.eventReader.nextEvent();
                if (xmlEvent.isStartElement()) {
                    this.handleStartElement(this.eventReader, xmlEvent.asStartElement());
                    continue;
                }
                if (xmlEvent.isEndElement()) {
                    this.handleEndElement(xmlEvent.asEndElement());
                    continue;
                }
                if (!xmlEvent.isCharacters()) continue;
                this.handleCharacters(xmlEvent.asCharacters());
            }
        }

        private void handleCharacters(Characters characters) {
            this.consumer.consumeCharacters(characters);
        }

        private void handleEndElement(EndElement endElement) {
            String name = endElement.getName().getLocalPart();
            this.END_ELEMENT_CONSUMER_METHODS.getOrDefault(name, element -> this.verifyIgnoredTag(name)).accept(endElement);
        }

        private void handleStartElement(XMLEventReader eventReader, StartElement startElement) throws XMLStreamException {
            String name = startElement.getName().getLocalPart();
            if (this.consumer.getSkippedTags().contains(name)) {
                this.skipUntilEnd(eventReader, name);
            }
            this.START_ELEMENT_CONSUMER_METHODS.getOrDefault(name, element -> this.verifyIgnoredTag(name)).accept(startElement);
        }

        private void skipUntilEnd(XMLEventReader eventReader, String name) throws XMLStreamException {
            XMLEvent xmlEvent;
            while (!(xmlEvent = eventReader.nextEvent()).isEndElement() || !xmlEvent.asEndElement().getName().getLocalPart().equals(name)) {
            }
        }

        private void verifyIgnoredTag(String name) {
            if (!this.consumer.getIgnoredTags().contains(name)) {
                throw new IllegalArgumentException("Unrecognized tag " + name);
            }
        }

        public CodeNarcAnalysis getAnalysis() {
            return this.consumer.getAnalysis();
        }

        public CodeNarcXmlEventProcessor(XMLEventReader eventReader) {
            Map.Entry[] entryArray = new Map.Entry[10];
            entryArray[0] = Map.entry("CodeNarc", this.consumer::consumeEndCodeNarc);
            entryArray[1] = Map.entry("Report", this.consumer::consumeEndReport);
            entryArray[2] = Map.entry("Project", this.consumer::consumeEndProject);
            entryArray[3] = Map.entry("SourceDirectory", this.consumer::consumeEndSourceDirectory);
            entryArray[4] = Map.entry("PackageSummary", this.consumer::consumeEndPackageSummary);
            entryArray[5] = Map.entry("Package", this.consumer::consumeEndPackage);
            entryArray[6] = Map.entry("File", this.consumer::consumeEndFile);
            entryArray[7] = Map.entry("Violation", this.consumer::consumeEndViolation);
            entryArray[8] = Map.entry("SourceLine", this.consumer::consumeEndSourceLine);
            entryArray[9] = Map.entry("Message", this.consumer::consumeEndMessage);
            this.END_ELEMENT_CONSUMER_METHODS = Map.ofEntries(entryArray);
            Map.Entry[] entryArray2 = new Map.Entry[10];
            entryArray2[0] = Map.entry("CodeNarc", this.consumer::consumeStartCodeNarc);
            entryArray2[1] = Map.entry("Report", this.consumer::consumeStartReport);
            entryArray2[2] = Map.entry("Project", this.consumer::consumeStartProject);
            entryArray2[3] = Map.entry("SourceDirectory", this.consumer::consumeStartSourceDirectory);
            entryArray2[4] = Map.entry("PackageSummary", this.consumer::consumeStartPackageSummary);
            entryArray2[5] = Map.entry("Package", this.consumer::consumeStartPackage);
            entryArray2[6] = Map.entry("File", this.consumer::consumeStartFile);
            entryArray2[7] = Map.entry("Violation", this.consumer::consumeStartViolation);
            entryArray2[8] = Map.entry("SourceLine", this.consumer::consumeStartSourceLine);
            entryArray2[9] = Map.entry("Message", this.consumer::consumeStartMessage);
            this.START_ELEMENT_CONSUMER_METHODS = Map.ofEntries(entryArray2);
            this.eventReader = eventReader;
        }

        public XMLEventReader getEventReader() {
            return this.eventReader;
        }

        public CodeNarcXmlEventConsumer getConsumer() {
            return this.consumer;
        }

        public Map<String, Consumer<EndElement>> getEND_ELEMENT_CONSUMER_METHODS() {
            return this.END_ELEMENT_CONSUMER_METHODS;
        }

        public Map<String, Consumer<StartElement>> getSTART_ELEMENT_CONSUMER_METHODS() {
            return this.START_ELEMENT_CONSUMER_METHODS;
        }
    }
}

