/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.report;

import io.github.crizzis.codenarc.parser.CodeNarcAnalysis;
import io.github.crizzis.codenarc.report.Localizable;
import io.github.crizzis.codenarc.report.PackageSummaryTableRenderer;
import io.github.crizzis.codenarc.report.ResultWalker;
import io.github.crizzis.codenarc.report.SummaryTableRenderer;
import io.github.crizzis.codenarc.report.TableRenderer;
import io.github.crizzis.codenarc.report.ViolationTableRenderer;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.sink.Sink;
import org.codenarc.results.DirectoryResults;
import org.codenarc.results.Results;

@Named
@Singleton
public class CodeNarcReportGenerator
implements Localizable {
    private static final int MAX_PRIORITY = 3;
    private static final String KEY_VALUE_SEPARATOR = ": ";
    private final ResultWalker resultWalker = new ResultWalker();

    public void generate(CodeNarcAnalysis input, Sink sink, Locale locale) {
        sink.head();
        this.generateHead(input, sink, locale);
        sink.head_();
        sink.body();
        this.generateBody(input, sink, locale);
        sink.body_();
    }

    private void generateHead(CodeNarcAnalysis input, Sink sink, Locale locale) {
        sink.title();
        sink.text(this.getCodeNarcMessages(locale).getString("report.codenarc.name"));
        sink.title_();
    }

    private void generateBody(CodeNarcAnalysis input, Sink sink, Locale locale) {
        this.generateHeading(input, sink, locale);
        this.generateSummary(input, sink, locale);
        if (this.hasViolations(input)) {
            this.generatePackageSummary(input, sink, locale);
            this.generateFileViolations(input, sink, locale);
        }
    }

    private void generateHeading(CodeNarcAnalysis input, Sink sink, Locale locale) {
        sink.section1();
        this.printSectionTitle(sink, this.getCodeNarcMessages(locale).getString("report.codenarc.name"));
        this.printParagraph(sink, this.getCodeNarcMessages(locale).getString("report.codenarc.content_description"));
        this.printKeyValue(sink, this.getCodeNarcMessages(locale).getString("report.codenarc.version_caption"), input.getCodeNarcVersion());
        this.printKeyValue(sink, this.getCodeNarcMessages(locale).getString("report.codenarc.generation_time_caption"), input.getReportTimestamp());
        sink.section1_();
    }

    private void generateSummary(CodeNarcAnalysis input, Sink sink, Locale locale) {
        sink.section1();
        this.printSectionTitle(sink, this.getCodeNarcMessages(locale).getString("report.codenarc.summary"));
        this.printTable(sink, new SummaryTableRenderer(locale), List.of((DirectoryResults)input.getResults()));
        sink.section1_();
    }

    private void generatePackageSummary(CodeNarcAnalysis input, Sink sink, Locale locale) {
        sink.section1();
        this.printSectionTitle(sink, this.getCodeNarcMessages(locale).getString("report.codenarc.package_summary"));
        Iterator<String> sourceRootDirectories = input.getSourceDirectories().iterator();
        input.getResults().getChildren().forEach(sourceRoot -> {
            if (sourceRootDirectories.hasNext()) {
                this.printSourceDirectoryTitle(sink, (String)sourceRootDirectories.next(), locale);
            }
            this.printResultTable(sink, new PackageSummaryTableRenderer(locale), (Results)sourceRoot, ResultWalker.DIRECTORIES_WITH_FILES);
        });
        sink.section1_();
    }

    private void generateFileViolations(CodeNarcAnalysis input, Sink sink, Locale locale) {
        sink.section1();
        this.printSectionTitle(sink, this.getCodeNarcMessages(locale).getString("report.codenarc.files"));
        Iterator<String> sourceRootDirectories = input.getSourceDirectories().iterator();
        CurrentPackageContext context = new CurrentPackageContext();
        this.resultWalker.walk(input.getResults(), ResultWalker.DIRECTORIES_WITH_FILES.or(ResultWalker.FILES).or(ResultWalker.SOURCE_ROOTS), results -> {
            if (results.isFile()) {
                this.printSubSubSectionTitle(sink, this.toFilePath(context.getCurrentPackage(), (Results)results));
                this.printTable(sink, new ViolationTableRenderer(locale), results.getViolations());
            } else {
                if (this.isSourceRoot((Results)results) && sourceRootDirectories.hasNext()) {
                    this.printSourceDirectoryTitle(sink, (String)sourceRootDirectories.next(), locale);
                }
                context.setCurrentPackage((Results)results);
            }
        });
        sink.section1_();
    }

    private void printSectionTitle(Sink sink, String title) {
        sink.sectionTitle1();
        sink.text(title);
        sink.sectionTitle1_();
    }

    private void printSourceDirectoryTitle(Sink sink, String sourceDirectory, Locale locale) {
        sink.sectionTitle2();
        sink.text(this.getCodeNarcMessages(locale).getString("report.codenarc.source_directory") + KEY_VALUE_SEPARATOR);
        sink.italic();
        sink.text(sourceDirectory);
        sink.italic_();
        sink.sectionTitle2_();
    }

    private void printSubSubSectionTitle(Sink sink, String title) {
        sink.sectionTitle3();
        sink.text(title);
        sink.sectionTitle3_();
    }

    private void printKeyValue(Sink sink, String key, String value) {
        sink.paragraph();
        sink.text(key + KEY_VALUE_SEPARATOR);
        sink.italic();
        sink.text(value);
        sink.italic_();
        sink.paragraph_();
    }

    private void printParagraph(Sink sink, String paragraphText) {
        sink.paragraph();
        sink.text(paragraphText);
        sink.paragraph_();
    }

    private <T> void printTable(Sink sink, TableRenderer<T> renderer, List<T> elements) {
        renderer.renderTable(sink, elements);
    }

    private void printResultTable(Sink sink, TableRenderer<Results> renderer, Results root, Predicate<Results> include) {
        renderer.renderTable(sink, renderingCallback -> this.resultWalker.walk(root, include, (Consumer<Results>)renderingCallback));
    }

    private boolean hasViolations(CodeNarcAnalysis input) {
        return input.getResults().getNumberOfFilesWithViolations(3, true) > 0;
    }

    private String toFilePath(Results directory, Results file) {
        return (String)(StringUtils.isBlank((CharSequence)directory.getPath()) ? "" : directory.getPath() + "/") + file.getPath();
    }

    private boolean isSourceRoot(Results results) {
        return results.getPath().isBlank();
    }

    private static class CurrentPackageContext {
        private Results currentPackage;

        private CurrentPackageContext() {
        }

        public Results getCurrentPackage() {
            return this.currentPackage;
        }

        public void setCurrentPackage(Results currentPackage) {
            this.currentPackage = currentPackage;
        }
    }
}

