/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.report;

import io.github.crizzis.codenarc.report.Localizable;
import io.github.crizzis.codenarc.report.TableRenderer;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.codenarc.results.DirectoryResults;

class SummaryTableRenderer
implements TableRenderer<DirectoryResults>,
Localizable {
    private static final int PRIORITY_ONE = 1;
    private static final int PRIORITY_TWO = 2;
    private static final int PRIORITY_THREE = 3;
    private final List<String> headers;

    SummaryTableRenderer(Locale locale) {
        ResourceBundle messages = this.getCodeNarcMessages(locale);
        this.headers = List.of(messages.getString("report.codenarc.total_files"), messages.getString("report.codenarc.files_with_violations"), messages.getString("report.codenarc.total_violations"), messages.getString("report.codenarc.priority_one_violations"), messages.getString("report.codenarc.priority_two_violations"), messages.getString("report.codenarc.priority_three_violations"));
    }

    @Override
    public void renderCell(Sink sink, DirectoryResults element, int index) {
        sink.text(String.valueOf(this.getValue(element, index)));
    }

    public int getValue(DirectoryResults element, int index) {
        switch (index) {
            case 0: {
                return element.getTotalNumberOfFiles(false);
            }
            case 1: {
                return element.getNumberOfFilesWithViolations(3);
            }
            case 2: {
                return element.getNumberOfViolationsWithPriority(1) + element.getNumberOfViolationsWithPriority(2) + element.getNumberOfViolationsWithPriority(3);
            }
            case 3: {
                return element.getNumberOfViolationsWithPriority(1);
            }
            case 4: {
                return element.getNumberOfViolationsWithPriority(2);
            }
            case 5: {
                return element.getNumberOfViolationsWithPriority(3);
            }
        }
        throw new IllegalArgumentException("Invalid table cell index");
    }

    @Override
    public List<String> getHeaders() {
        return this.headers;
    }
}

