/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.report;

import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.doxia.sink.Sink;

public interface TableRenderer<T> {
    default public void renderTable(Sink sink, Consumer<Consumer<T>> callback) {
        sink.table();
        this.renderHeader(sink);
        callback.accept(element -> this.renderRow(sink, element));
        sink.table_();
    }

    default public void renderTable(Sink sink, Iterable<T> elements) {
        this.renderTable(sink, elements::forEach);
    }

    default public void renderHeader(Sink sink) {
        sink.tableRow();
        this.getHeaders().forEach(header -> {
            sink.tableHeaderCell();
            sink.text(header);
            sink.tableHeaderCell_();
        });
        sink.tableRow_();
    }

    public List<String> getHeaders();

    default public void renderRow(Sink sink, T element) {
        sink.tableRow();
        for (int i = 0; i < this.getColumnCount(); ++i) {
            sink.tableCell();
            this.renderCell(sink, element, i);
            sink.tableCell_();
        }
        sink.tableRow_();
    }

    public void renderCell(Sink var1, T var2, int var3);

    default public int getColumnCount() {
        return this.getHeaders().size();
    }
}

